unit BasicDynIntProcsU;

// POZOR! VSECHNY OPERACE POCITAJI S TIM, ZE V POLI NEJSOU ZADNE PREBYTECNE BYTY,
// TJ. NEJVYSSI BYTE POLE JE NENULOVY

interface

uses Math,
     Types,
     Dialogs,
     DynIntU,
     ConvOrdU;

//------------------------------------------------------------------------------

procedure BShl(var Target: TDynInt; const Distance: Integer); // bitovy posun doleva
procedure BShr(var Target: TDynInt; const Distance: Integer); // -II- doprava
procedure BInc(var Target: TDynInt); // zvyseni o 1
procedure BDec(var Target: TDynInt); // snizeni o 1
procedure BAdd(var Target: TDynInt; const Addend: TDynInt); // scitani
procedure BSub(var Target: TDynInt; const Substrahend: TDynInt); // odecitani
procedure BMul(var Target: TDynInt; const Multiplied, Multiplicant: TDynInt); // nasobeni
procedure BDiv(var Target: TDynInt; const Dividend, Divisor: TDynInt); // deleni
procedure BDivMod(var Target, Remainder: TDynInt; const Dividend, Divisor: TDynInt); // se zbytkem
procedure BMod(var Target: TDynInt; const Dividend, Divisor: TDynInt); // jen zbytek
procedure BGcd(var Target: TDynInt; const A, B: TDynInt); // nejv. spol. delitel
procedure BLcm(var Target: TDynInt; const A, B: TDynInt); // nejm. spol. nasobek


function BGreater(const A, B: TDynInt): Boolean; // je vetsi
function BEqual(const A, B: TDynInt): Boolean; // je rovno
function BGreaterEqual(const A, B: TDynInt): Boolean; // je vetsi nebo rovno
function BIsZero(const A: TDynInt): Boolean; // je nula
function BIsOne(const A: TDynInt): Boolean; // je jedna

function DynIntBitLength(const A: TDynInt): Integer; // delka pole v bitech
function EndingZeros(const A: TDynInt): Integer; // pocet nul na konci

procedure BMovInt64(var Target: TDynInt; N: UInt64); // prirazeni kladneho 8bytoveho cisla
procedure BMovMem(var Target: TDynInt; Ptr: Pointer; Size: Integer); // prirazeni dat z pameti

procedure CancelFrac(var A, B: TDynInt); // pokraceni zlomku

function DynIntToStr(const A: TDynInt): String;
function DynIntToHex(const A: TDynInt): String;

procedure StrToDynInt(var A: TDynInt; Str: String);
procedure HexToDynInt(var A: TDynInt; Hex: String);

//==============================================================================

implementation

//==============================================================================

uses SysUtils;

//------------------------------------------------------------------------------

function BIsZero(const A: TDynInt): Boolean;
begin
  Result := (A.Length = 1) and (DIGet(A, 0) = 0);
end;

//------------------------------------------------------------------------------

function BIsOne(const A: TDynInt): Boolean;
begin
  Result := (A.Length = 1) and (DIGet(A, 0) = 1);
end;

//------------------------------------------------------------------------------

function DynIntBitLength(const A: TDynInt): Integer;
var B: Byte;
begin
  if BIsZero(A) then Result := 0 else begin
    Result := (A.Length - 1) shl 3; // *8
    B := DIGet(A, A.Length - 1);
    repeat
      Inc(Result);
      B := B shr 1;
    until B = 0;
  end;
end;

//------------------------------------------------------------------------------

function EndingZeros(const A: TDynInt): Integer;
var B: Byte;
begin
  Result := 0;
  if not BIsZero(A) then begin
    Result := 0;
    while DIGet(A, Result) = 0 do Inc(Result);
    B := DIGet(A, Result);
    Result := Result shl 3; //* 8
    while (B shr ((Result mod 8) + 1)) shl ((Result mod 8) + 1) = B do Inc(Result);
  end;
end;

//------------------------------------------------------------------------------
//------------------------------------------------------------------------------

procedure BInc(var Target: TDynInt);
var CF: Boolean; // Carry Flag - priznak prenosu; kdyz dojde k preteceni
    i: Cardinal;
    B: Byte;
begin
  i := 0;                          // inicializace
  CF := true;                      // nastavime "jako na preteceni"
  while CF do begin                // dokud se preteceni nezbavime
    if i = Target.Length then begin // kdyz uz se nevlezeme
      DISetLength(Target, i + 1);      // tak rozsirime
      DISet(Target, i, 1);              // ulozime jednicku
      CF := false;                 // a skoncime
    end else begin
      B := DIGet(Target, i);
      CF := B = 255;              // nastavime CF
      DISet(Target, i, B + 1);        // pricteme 1
    end;
    Inc(i);                        // zvysime promennou smycky
  end;
end;

//------------------------------------------------------------------------------

procedure BDec(var Target: TDynInt);
var CF: Boolean;
    i: Cardinal;
    B: Byte;
begin
  if not BIsZero(Target) then begin
    i := 0;                          // inicializace
    CF := true;                      // nastavime "jako na podteceni"
    while CF do begin                // dokud se podteceni nezbavime
      B := DIGet(Target, i);
      CF := B = 0;                  // nastavime CF
      DISet(Target, i, B - 1);        // odecteme 1
      Inc(i);                       // zvysime promennou smycky
    end;
  end;
end;

//------------------------------------------------------------------------------

procedure BAdd(var Target: TDynInt; const Addend: TDynInt);
var i, j: Cardinal;
    CF: Boolean;
begin
  for i := 0 to Addend.Length - 1 do begin
    if i >= Target.Length then begin         // kdyz uz neni k cemu pricitat
      DISetLength(Target, Addend.Length);   // tak to proste zkopirujeme
      for j := i to Addend.Length - 1 do DISet(Target, j, DIGet(Addend, j));
      Break;
    end else begin
      CF := DIGet(Target, i) + DIGet(Addend, i) > 255; // CF - kdyz je soucet vetsi nez byte
      DISet(Target, i, DIGet(Target, i) + DIGet(Addend, i));
      j := i;
      while CF do begin                    // pricitame prebytek ze souctu
        Inc(j);
        if j >= Target.Length then begin     // kdyz neni kam pricitat
          DISetLength(Target, Target.Length + 1);
          DISet(Target, j, 1);                  // tak zvetsime misto a ulozime 1
          CF := false;
        end else begin
          CF := DIGet(Target, j) = 255;           // preteceni bude jen pri plnem bytu
          DISet(Target, j, DIGet(Target, j) + 1);
        end;
      end;
    end;
  end;
end;

//------------------------------------------------------------------------------

procedure BSub(var Target: TDynInt; const Substrahend: TDynInt);
var i, j: Integer;     // VAROVANI!!! MUZE ODECIST JEN MENSI OD VETSIHO
    CF: Boolean;       // JINAK BLBNE!!! (NECEKANE :) )
begin
  for i := 0 to Substrahend.Length - 1 do begin
    CF := DIGet(Substrahend, i) > DIGet(Target, i);
    DISet(Target, i, DIGet(Target, i) - DIGet(Substrahend, i));
    j := i;
    while CF do begin           // postup stejny
      Inc(j);                   // jako u secitani
      CF := DIGet(Target, j) = 0;
      DISet(Target, j, DIGet(Target, j) - 1);
    end;
  end;
  i := Target.Length - 1;            // vycisteni od prebytecnych bytu
  while (i > 0) and (DIGet(Target, i) = 0) do Dec(i);
  DISetLength(Target, i + 1);
end;

//------------------------------------------------------------------------------

procedure BShl(var Target: TDynInt; const Distance: Integer);
var Source: TDynInt;
    Cur, Prev: TRec2;        // Recordy o velikosti 2 byty s ruznym pristupem
    i: Integer;
    ShlDist, MoveDist: Integer; // MoveDist - o kolik bYtu se posuneme,
begin                        // ShlDist - o kolik bItu se jeste pak posuneme
  if Distance > 0 then begin
    MoveDist := Distance shr 3;
    ShlDist := Distance and 7;
    if ShlDist = 0 then begin   // staci posouvat jen byty
      DISetLength(Target, Target.Length + MoveDist);
      for i := Target.Length - MoveDist - 1 downto 0 do
        DISet(Target, i + Movedist, DIGet(Target, i));
    end else begin
      DICreate(Source);
      DICopy(Source, Target);   // zkopirujeme posouvane
      DISetLength(Target, Target.Length + MoveDist);
      Prev.fWord := 0;          // inicializace
      for i := 0 to Source.Length - 1 do begin
        Cur.fWord := DIGet(Source, i);     // nacteme byte na posunuti
        Cur.fWord := Cur.fWord shl ShlDist;  // posuneme ho
        DISet(Target, i + MoveDist, Cur.fByte[0] or Prev.fByte[1]); // vlozime
        Prev := Cur;     // spolu se zbytkem predchoziho, pak zamenime
      end;
      if Prev.fByte[1] > 0 then begin  // kdyz zbyde z posledniho
        DISetLength(Target, Target.Length + 1); // tak rozsirime
        DISet(Target, Target.Length - 1, Prev.fByte[1]); // a ulozime
      end;
      DIFree(Source);
    end;
    for i := 0 to MoveDist - 1 do DISet(Target, i, 0); // vynulujeme prazdne
  end else if Distance < 0 then BShr(Target, -Distance);
end;

//------------------------------------------------------------------------------

procedure BShr(var Target: TDynInt; const Distance: Integer);
var Source: TDynInt;     // viz BShl, je to podobne
    Cur, Prev: TRec2;
    i: Integer;
    ShlDist, MoveDist: Integer;   // ShlDist protoze se pouziva se Shl i kdyz je v
begin                                                                   // BShr
  if Distance > 0 then begin
    MoveDist := Distance shr 3;
    ShlDist := 8 - (Distance and 7); // casteji se pouzije 8-shldist tak to tak ulozime
    if MoveDist >= Target.Length then begin // kdyz posouvame o vic nez cislo ma
      DIFree(Target);               // tak proste vynulujeme
      DICreate(Target, 1);
    end else begin // Tady je to jako test na nulu
      if ShlDist = 8 then begin  // kdyz je posun bitu nulovy, presuneme jen byty
        for i := MoveDist to Target.Length-1 do DISet(Target, i - MoveDist, DIGet(Target, i));
      end else begin
        DICreate(Source);
        DICopy(Source, Target); // zkopirujeme
        Prev.fWord := DIGet(Source, Source.Length-1) shl ShlDist; // obstarame "posledni" byt
        DISet(Target, Target.Length - MoveDist - 1, Prev.fByte[1]);
        for i := Source.Length - 2 downto MoveDist do begin
          Cur.fWord := DIGet(Source, i) shl ShlDist; // nacteme a posuneme
          DISet(Target, i - MoveDist, Cur.fByte[1] or Prev.fByte[0]); // ulozime spolu
          Prev := Cur;    // zbytkem z predchoziho bytu, prohodime
        end;
      end;
      if MoveDist > 0 then DISetLength(Target, Target.Length - MoveDist); // upravime velikost DI
      if (Target.Length <> 1) and (DIGet(Target, Target.Length-1) = 0) // kdyz zustane
       then DISetLength(Target, Target.Length-1); // posledni byt nulovy, odstranime
    end;                                         // pokud to neni zaroven prvni byt
  end else if Distance < 0 then BShl(Target, -Distance);
end;

//------------------------------------------------------------------------------

procedure BMul(var Target: TDynInt; const Multiplied, Multiplicant: TDynInt);
var i, j, LastMove: Integer;
    TmpA, TmpB: TDynInt;
    B: Byte;
begin
  if BIsZero(Multiplied) or BIsZero(Multiplicant) then begin
    DIFree(Target);
    DICreate(Target, 1);
  end else if BIsOne(Multiplied) then begin
    if Target.Mem <> Multiplicant.Mem then DICopy(Target, Multiplicant);
  end else if BIsOne(Multiplicant) then begin
    if Target.Mem <> Multiplied.Mem then DICopy(Target, Multiplied);
  end else begin
    DICreate(TmpA, 1); // inicializujeme
    DICreate(TmpB);
    DICopy(TmpB, Multiplied);
    LastMove := 0;
    for i := 0 to Multiplicant.Length - 1 do begin // prochazime po bytech
      B := DIGet(Multiplicant, i);
      if B <> 0 then for j := 0 to 7 do begin // pracujeme jen kdyz neni B nula
        if (B and 1) <> 0 then begin          // test na pritomnost bitu
          BShl(TmpB, (i shl 3) + j - LastMove); // jestli je, tak posuneme (vynasobime mocninou 2)
          LastMove := (i shl 3) + j; // ulozime nove posunuti
          BAdd(TmpA, TmpB);          // pricteme k mezisouctu
        end;
        B := B shr 1;
        if B = 0 then Break;
      end;
    end;
    DICopy(Target, TmpA);    // vysledek ulozime
    DIFree(TmpA);            // zbavime se docasnych
    DIFree(TmpB);
  end;  
end;

//------------------------------------------------------------------------------

function BGreater(const A, B: TDynInt): Boolean;
var i: Integer;
begin     // V  nejdriv je test na velikosti
  if A.Length <> B.Length then Result := A.Length > B.Length else begin
    Result := false;
    for i := A.Length-1 downto 0 do if DIGet(A, i) <> DIGet(B, i) then begin
      Result := DIGet(A, i) > DIGet(B, i);
      Break;
    end;
  end;
end;

//------------------------------------------------------------------------------

function BEqual(const A, B: TDynInt): Boolean;
var i: Integer;
begin
  if A.Length <> B.Length then Result := false else begin
    Result := true;
    for i := A.Length-1 downto 0 do if DIGet(A, i) <> DIGet(B, i) then begin
      Result := false;
      Break;
    end;
  end;
end;

//------------------------------------------------------------------------------

function BGreaterEqual(const A, B: TDynInt): Boolean;
begin
  Result := not BGreater(B, A); // jen negace vyroku
end;

//------------------------------------------------------------------------------

procedure BDiv(var Target: TDynInt; const Dividend, Divisor: TDynInt);
var TmpA, TmpB: TDynInt;
    DvsLength, Diff: Integer;
begin
  if BIsZero(Divisor) then raise EDivByZero.Create('division by zero') else begin
    DICreate(TmpA);            // vytvori se docasne promenne
    DICreate(TmpB);            // do nich se ulozi Dividend a Divisor
    DICopy(TmpA, Dividend);    // pro pripad ze jeden z nich je Target
    DICopy(TmpB, Divisor);
    DIFree(Target);            // Target vynulujeme
    DICreate(Target, 1);
    DvsLength := DynIntBitLength(TmpB);   // zjistime delku divisoru - ta bude koncova
    Diff := DynIntBitLength(TmpA) - DvsLength;  // a taky rozdil delek
    if Diff > 0 then begin           // kdyz je rozdil kladny, zacneme delit
      BShl(TmpB, Diff);              // posuneme delitele na uroven delence
      while DynIntBitLength(TmpB) > DvsLength do begin
        if BGreaterEqual(TmpA, TmpB) then begin  // kdyz je delene cislo vetsi,
          BInc(Target);                         // zvetsime vysledek
          BSub(TmpA, TmpB);                     // a odecteme
          if DynIntBitLength(TmpA) < DvsLength then begin // kdyz uz jsme pod DvsLength
            BShl(Target, DynIntBitLength(TmpB) - DvsLength); // tak posuneme jen o zbytek
            BShr(TmpB, DynIntBitLength(TmpB) - DvsLength);
          end else begin
            Diff := DynIntBitLength(TmpB) - DynIntBitLength(TmpA);
            BShl(Target, Diff);      // jinak posuneme na stejnou delku
            BShr(TmpB, Diff);
          end;
        end else begin
          BShr(TmpB, 1);             // kdyz je i pri stejne delce delenec vetsi,
          BShl(Target, 1);           // tak posuneme obe o jedna
        end;
      end;
    end;
    if BGreaterEqual(TmpA, TmpB) then BInc(Target);
    DIFree(TmpA);      // zbavime se docasnych
    DIFree(TmpB);
  end;
end;

//------------------------------------------------------------------------------

procedure BDivMod(var Target, Remainder: TDynInt; const Dividend, Divisor: TDynInt);
var TmpA, TmpB: TDynInt;
    DvsLength, Diff: Integer;
begin
  if BIsZero(Divisor) then raise EDivByZero.Create('division by zero') else begin
    DICreate(TmpA);            // vytvori se docasne promenne
    DICreate(TmpB);            // do nich se ulozi Dividend a Divisor
    DICopy(TmpA, Dividend);    // pro pripad ze jeden z nich je Target
    DICopy(TmpB, Divisor);
    DIFree(Target);            // Target vynulujeme
    DICreate(Target, 1);
    DvsLength := DynIntBitLength(TmpB);   // zjistime delku divisoru - ta bude koncova
    Diff := DynIntBitLength(TmpA) - DvsLength;  // a taky rozdil delek
    if Diff > 0 then begin           // kdyz je rozdil kladny, zacneme delit
      BShl(TmpB, Diff);              // posuneme delitele na uroven delence
      while DynIntBitLength(TmpB) > DvsLength do begin
        if BGreaterEqual(TmpA, TmpB) then begin  // kdyz je delene cislo vetsi,
          BInc(Target);                         // zvetsime vysledek
          BSub(TmpA, TmpB);                     // a odecteme
          if DynIntBitLength(TmpA) < DvsLength then begin // kdyz uz jsme pod DvsLength
            BShl(Target, DynIntBitLength(TmpB) - DvsLength); // tak posuneme jen o zbytek
            BShr(TmpB, DynIntBitLength(TmpB) - DvsLength);
          end else begin
            Diff := DynIntBitLength(TmpB) - DynIntBitLength(TmpA);
            BShl(Target, Diff);
            BShr(TmpB, Diff);
          end;
        end else begin
          BShr(TmpB, 1);             // kdyz je i pri stejne delce delenec vetsi,
          BShl(Target, 1);           // tak posuneme obe o jedna
        end;
      end;
    end;
    if BGreaterEqual(TmpA, TmpB) then begin
      BInc(Target);
      BSub(TmpA, TmpB);
    end;
    DICopy(Remainder, TmpA); // ulozeni zbytku
    DIFree(TmpA);      // zbavime se docasnych
    DIFree(TmpB);
  end;
end;

//------------------------------------------------------------------------------

procedure BMod(var Target: TDynInt; const Dividend, Divisor: TDynInt);
var TmpA, TmpB: TDynInt;
    DvsLength, Diff: Integer;
begin
  if BIsZero(Divisor) then raise EDivByZero.Create('division by zero') else begin
    DICreate(TmpA);            // vytvori se docasne promenne
    DICreate(TmpB);            // do nich se ulozi Dividend a Divisor
    DICopy(TmpA, Dividend);    // pro pripad ze jeden z nich je Target
    DICopy(TmpB, Divisor);
    DvsLength := DynIntBitLength(TmpB);   // zjistime delku divisoru - ta bude koncova
    Diff := DynIntBitLength(TmpA) - DvsLength;  // a taky rozdil delek
    if Diff > 0 then begin           // kdyz je rozdil kladny, zacneme delit
      BShl(TmpB, Diff);              // posuneme delitele na uroven delence
      while DynIntBitLength(TmpB) > DvsLength do begin
        if BGreaterEqual(TmpA, TmpB) then begin  // kdyz je delene cislo vetsi,
          BSub(TmpA, TmpB);                     // a odecteme
          if DynIntBitLength(TmpA) < DvsLength then begin // kdyz uz jsme pod DvsLength
            BShr(TmpB, DynIntBitLength(TmpB) - DvsLength);
          end else begin
            Diff := DynIntBitLength(TmpB) - DynIntBitLength(TmpA);
            BShr(TmpB, Diff);
          end;
        end else BShr(TmpB, 1);             // kdyz je i pri stejne delce delenec vetsi,
      end;
    end;
    if BGreaterEqual(TmpA, TmpB) then begin
      BSub(TmpA, TmpB);
    end;
    DICopy(Target, TmpA); // ulozeni zbytku
    DIFree(TmpA);      // zbavime se docasnych
    DIFree(TmpB);
  end;
end;

//------------------------------------------------------------------------------

procedure BGcd(var Target: TDynInt; const A, B: TDynInt);
var TmpA, TmpB, TmpC: TDynInt;
begin
  DICreate(TmpA);
  DICreate(TmpB);
  DICreate(TmpC);
  if BGreater(A, B) then begin
    DICopy(TmpA, A);     // zkopirujeme tak, aby v TmpA byla vetsi hodnota
    DICopy(TmpB, B);
  end else begin
    DICopy(TmpA, B);
    DICopy(TmpB, A);
  end;
  while not BIsZero(TmpB) do begin   // Eukliduv algoritmus
    DICopy(TmpC, TmpB);
    BMod(TmpB, TmpA, TmpB);
    DICopy(TmpA, TmpC);
  end;
  DICopy(Target, TmpA);
  DIFree(TmpA);
  DIFree(TmpB);
  DIFree(TmpC);
end;

//------------------------------------------------------------------------------

procedure BLcm(var Target: TDynInt; const A, B: TDynInt);
var TmpA, TmpB, TmpC: TDynInt;
begin
  DICreate(TmpA);
  DICreate(TmpB);
  DICreate(TmpC);
  if BGreater(A, B) then begin
    DICopy(TmpA, A);     // zkopirujeme tak, aby v TmpA byla vetsi hodnota
    DICopy(TmpB, B);
  end else begin
    DICopy(TmpA, B);
    DICopy(TmpB, A);
  end;
  while not BIsZero(TmpB) do begin   // Eukliduv algoritmus
    DICopy(TmpC, TmpB);
    BMod(TmpB, TmpA, TmpB);
    DICopy(TmpA, TmpC);
  end;
  BDiv(TmpC, A, TmpA);   // v tuto chvili je GCD v TmpA;
  BMul(TmpC, TmpC, B);
  DICopy(Target, TmpC);
  DIFree(TmpA);
  DIFree(TmpB);
  DIFree(TmpC);
end;

//------------------------------------------------------------------------------

procedure BMovInt64(var Target: TDynInt; N: UInt64);
var P: PRec8;
    i: Integer;
begin
  P := @N;
  i := 7;
  while (P.fByte[i] = 0) and (i > 0) do Dec(i);
  DISetLength(Target, i + 1);
  for i := i downto 0 do DISet(Target, i, P.fByte[i]);
end;

//------------------------------------------------------------------------------

procedure BMovMem(var Target: TDynInt; Ptr: Pointer; Size: Integer);
var Tmp: TDynInt;
begin
  Tmp.Length:= Size;
  Tmp.Mem:= Ptr;
  DICopy(Target, Tmp);
end;

//------------------------------------------------------------------------------

procedure CancelFrac(var A, B: TDynInt);
var Tmp: TDynInt;
begin
  DICreate(Tmp);
  BGcd(Tmp, A, B);
  BDiv(A, A, Tmp);
  BDiv(B, B, Tmp);
  DIFree(Tmp);
end;

//------------------------------------------------------------------------------

function DynIntToStr(const A: TDynInt): String;
var Temp, Digit, Cnst10: TDynInt;
begin
  if BIsZero(A) then Result := '0' else begin
    DICreate(Cnst10, 1);
    DISet(Cnst10, 0, 10);
    DICreate(Digit);
    DICreate(Temp);
    DICopy(Temp, A);
    repeat
      BDivMod(Temp, Digit, Temp, Cnst10);
      Result := IntToStr(DIGet(Digit, 0)) + Result;
    until BIsZero(Temp);
    DIFree(Temp);
    DIFree(Digit);
    DIFree(Cnst10);
  end;
end;

//------------------------------------------------------------------------------

function DynIntToHex(const A: TDynInt): String;
var i: Integer;
begin
  if BIsZero(A) then Result := '0' else begin
    for i := A.Length-1 downto 0 do Result := Result + IntToHex(DIGet(A, i), 2);
    if Result[1] = '0' then Delete(Result, 1, 1);
  end;  
end;

//------------------------------------------------------------------------------

procedure StrToDynInt(var A: TDynInt; Str: String);
var Temp, Sum, Cnst10: TDynInt;
    i: Integer;
begin
  if Str <> '' then begin
    DICreate(Temp, 1);
    DICreate(Sum, 1);
    DICreate(Cnst10, 1);
    DISet(Cnst10, 0, 10);
    i := 1;
    while (Str[i] = '0') and (i < Length(Str)) do Inc(i);
    Delete(Str, 1, i - 1);
    for i := 1 to Length(Str) do if Str[i] in ['0'..'9'] then begin
      BMul(Sum, Sum, Cnst10);
      DISet(Temp, 0, StrToInt(Str[i]));
      BAdd(Sum, Temp);
    end else raise EConvertError.Create('"'+Str+'" is not a valid decimal integer value');
    DICopy(A, Sum);
    DIFree(Temp);
    DIFree(Sum);
    DIFree(Cnst10);
  end else raise EConvertError.Create('nothing to convert');
end;

//------------------------------------------------------------------------------

procedure HexToDynInt(var A: TDynInt; Hex: String);
var i, L: Integer;
    Temp: TDynInt;
begin
  if Hex <> '' then begin
    i := 1;
    while (Hex[i] = '0') and (i < Length(Hex)) do Inc(i);
    Delete(Hex, 1, i - 1);
    L := Length(Hex);
    DICreate(Temp, (L + 1) div 2);
    for i := 1 to L do case Hex[i] of
      '0'..'9':
       if (L - i) and 1 = 1 then DISet(Temp, (L - i) div 2, StrToInt(Hex[i]) shl 4)
       else DISet(Temp, (L - i) div 2, DIGet(Temp, (L - i) div 2) or StrToInt(Hex[i]));
      'a', 'A':
       if (L - i) and 1 = 1 then DISet(Temp, (L - i) div 2, 10 shl 4)
       else DISet(Temp, (L - i) div 2, DIGet(Temp, (L - i) div 2) or 10);
      'b', 'B':
       if (L - i) and 1 = 1 then DISet(Temp, (L - i) div 2, 11 shl 4)
       else DISet(Temp, (L - i) div 2, DIGet(Temp, (L - i) div 2) or 11);
      'c', 'C':
       if (L - i) and 1 = 1 then DISet(Temp, (L - i) div 2, 12 shl 4)
       else DISet(Temp, (L - i) div 2, DIGet(Temp, (L - i) div 2) or 12);
      'd', 'D':
       if (L - i) and 1 = 1 then DISet(Temp, (L - i) div 2, 13 shl 4)
       else DISet(Temp, (L - i) div 2, DIGet(Temp, (L - i) div 2) or 13);
      'e', 'E':
       if (L - i) and 1 = 1 then DISet(Temp, (L - i) div 2, 14 shl 4)
       else DISet(Temp, (L - i) div 2, DIGet(Temp, (L - i) div 2) or 14);
      'f', 'F':
       if (L - i) and 1 = 1 then DISet(Temp, (L - i) div 2, 15 shl 4)
       else DISet(Temp, (L - i) div 2, DIGet(Temp, (L - i) div 2) or 15);
      else begin
        DIFree(Temp);
        raise EConvertError.Create('"'+Hex+'" is not a valid hexadecimal integer value');
      end;
    end;
    DICopy(A, Temp);
    DIFree(Temp);
  end else raise EConvertError.Create('nothing to convert');
end;

//------------------------------------------------------------------------------

end.

