unit RatNumU;

interface

uses BasicDynIntProcsU,
     DynIntU,
     ConvOrdU,
     Math;

type
  
  TNumber = class(TObject)     // objekt ktery to vsechno uchovava!
  private
    function GetRealValue: Extended;
    function GetHasIntPart: Boolean;
    function GetIsInt: Boolean;
    function GetCanBeInt64: Boolean;
    function GetInt64Value: Int64;
    procedure FreeTemp;
  public
    Minus: Boolean;
    Citatel: TDynInt;     // samotne cislo
    Jmenovatel: TDynInt;
    constructor Create;
    destructor Destroy; override;
    property RealValue: Extended read GetRealValue;  // hodnota v Extendedu
    property HasIntPart: Boolean read GetHasIntPart; // jestli ma celou cast
    property IsInt: Boolean read GetIsInt;       // jestli je cele cislo
    property CanBeInt64: Boolean read GetCanBeInt64; // jestli muze byt v Int64
    property Int64Value: Int64 read GetInt64Value;
    procedure AssignValue(Z: Int64); overload;
    procedure AssignValue(X: Extended); overload;    // prirazovani hodnot
    procedure AssignValue(S: TNumber); overload;
    procedure AssignValue(Cit, Jm: Int64); overload;
    procedure SetFromHexStr(Hex: String);         // nacte cele cislo z Hex retezce
    procedure SetFromDecStr(Dec: String);         // nacte cele cislo z Dec retezce
    function GetHexCitatel(const UseCaps: Boolean = true): String; // citatel v hex
    function GetDecCitatel: String;                                // citatel v dec
    function GetHexJmenovatel(const UseCaps: Boolean = true): String; // jmenovatel v hex
    function GetDecJmenovatel: String;                                // jmenovatel v dec
    function GetHexIntPart(const UseCaps: Boolean = true): String; // cela cast v hex
    function GetDecIntPart: String;                                // cela cast v dec
    function GetHexRemain(const UseCaps: Boolean = true): String;
    function GetDecRemain: String;
    function GetHexComplete(const MaxDigits: Cardinal; const UseCaps: Boolean = true): String;
    function GetDecComplete(const MaxDigits: Cardinal): String;
    function GetHexFract(const UseCaps: Boolean = true): String;
    function GetDecFract: String;
  end;

  TTempNumber = class(TNumber)
  public
    FreeMe: Boolean;
    constructor Create(const ForFree: Boolean);
    //destructor Destroy; override;
  end;


function RAdd(Nums: array of TNumber): TTempNumber; overload; // soucet
function RAdd(Nums: array of TNumber; const A: Int64; const B: Int64 = 1): TTempNumber; overload;
function RMul(Nums: array of TNumber): TTempNumber; overload; // soucin
function RMul(Nums: array of TNumber; const A: Int64; const B: Int64 = 1): TTempNumber; overload;

function MulInv(const X: TNumber): TTempNumber; // prevracena hodnota
function AddInv(const X: TNumber): TTempNumber; // opacne cislo

procedure AAdd(const Target: TNumber; const Addend: TNumber);
procedure AMul(const Target: TNumber; const Multiplicant: TNumber);

function RGreater(const A, B: TNumber): Boolean; overload;
function RGreater(const A: TNumber; const P: Int64; const Q: Int64 = 1): Boolean; overload;
function RGreaterEqual(const A, B: TNumber): Boolean; overload;
function RGreaterEqual(const A: TNumber; const P: Int64; const Q: Int64 = 1): Boolean; overload;
function REqual(const A, B: TNumber): Boolean; overload;
function REqual(const A: TNumber; const P: Int64; const Q: Int64 = 1): Boolean; overload;
function RLesser(const A, B: TNumber): Boolean; overload;
function RLesser(const A: TNumber; const P: Int64; const Q: Int64 = 1): Boolean; overload;
function RLesserEqual(const A, B: TNumber): Boolean; overload;
function RLesserEqual(const A: TNumber; const P: Int64; const Q: Int64 = 1): Boolean; overload;

function RAbs(const A: TNumber): TTempNumber;
function RTrunc(const A: TNumber): TTempNumber;
function RRound(const A: TNumber): TTempNumber;
function RFloor(const A: TNumber): TTempNumber;
function RCeil(const A: TNumber): TTempNumber;

function RSqr(const X: TNumber): TTempNumber;


implementation

uses Dialogs, SysUtils, ConvUtils;


constructor TTempNumber.Create(const ForFree: Boolean);
begin
  inherited Create;
  FreeMe := ForFree;
end;

//------------------------------------------------------------------------------
//------------------------------------------------------------------------------

constructor TNumber.Create;
begin
  inherited Create;
  DICreate(Citatel, 1);
  DICreate(Jmenovatel, 1);
  DISet(Jmenovatel, 0, 1);
end;

//------------------------------------------------------------------------------

destructor TNumber.Destroy;
begin
  if (not (Self is TTempNumber)) or ((Self as TTempNumber).FreeMe) then begin
    DIFree(Citatel);
    DIFree(Jmenovatel);
  end;
  inherited Destroy;
end;

//------------------------------------------------------------------------------

procedure TNumber.FreeTemp;
begin
  if Self is TTempNumber then (Self as TTempNumber).Free;
end;

//------------------------------------------------------------------------------

procedure TNumber.AssignValue(Z: Int64);
var U: UInt64;
begin
  if not BIsOne(Jmenovatel) then begin
    DIFree(Jmenovatel);
    DICreate(Jmenovatel, 1);
    DISet(Jmenovatel, 0, 1);
  end;
  if Z < 0 then begin
    Minus := true;
    U := -Z;
  end else begin
    Minus := false;
    U := Z;
  end;
  BMovInt64(Citatel, U);
end;

//------------------------------------------------------------------------------

procedure TNumber.AssignValue(X: Extended);
var P: PRec10;
    Z: TRec8;
    Exp, i: Integer;
begin
  if X < 0 then begin
    X := -X;
    Minus := true;
  end else Minus := false;
  Frexp(X, X, Exp);  // extrahujeme exponent
  Dec(Exp, 64);      // zmensime exponent, aby mantisa byla "cele cislo"
  P := @X;
  for i := 0 to 3 do Z.fWord[i] := P.fWord[i]; // zkopirujeme mantisu
  if not BIsOne(Jmenovatel) then begin
    DIFree(Jmenovatel);
    DICreate(Jmenovatel, 1);               // nastavime jmenovatel
    DISet(Jmenovatel, 0, 1);
  end;
  BMovInt64(Citatel, Z.fUInt64);              // nastavime citatel
  if Exp > 0 then BShl(Citatel, Exp) else BShl(Jmenovatel, -Exp); // posuneme o exp
  CancelFrac(Citatel, Jmenovatel);           // pokratime
end;

//------------------------------------------------------------------------------

procedure TNumber.AssignValue(S: TNumber);
begin
  Minus := S.Minus;
  DICopy(Citatel, S.Citatel);
  DICopy(Jmenovatel, S.Jmenovatel);
  S.FreeTemp;
end;

//------------------------------------------------------------------------------

procedure TNumber.AssignValue(Cit, Jm: Int64);
  function Gcd(const A, B: Int64): Int64; // nejvetsi spol. delitel
  begin                                   // rekurzivni eukliduv algoritmus
    if B = 0 then Result := A else Result := Gcd(B, A mod B);
  end;
var N: Int64;  
begin
  if Jm = 1 then AssignValue(Cit)
   else if Jm = -1 then AssignValue(-Cit) else if Jm <> 0 then begin
    if (Cit = 0) and not BIsZero(Citatel) then begin // kdyz je citatel nula
      DIFree(Citatel);                               // tak nulu ulozime :)
      DICreate(Citatel, 1);
      if not BIsOne(Jmenovatel) then begin
        DIFree(Jmenovatel);
        DICreate(Jmenovatel, 1);
        DISet(Jmenovatel, 0, 1);
      end;
      Minus := false;
    end else begin
      Minus := (Cit < 0) xor (Jm < 0);  // nastavime znamenko
      Cit := Abs(Cit);                  // obe cisla zmenime na kladne
      Jm := Abs(Jm);
      if Cit > Jm then N := Gcd(Cit, Jm) else N := Gcd(Jm, Cit); // zjistime GCD
      BMovInt64(Citatel, Cit div N);     // ulozime pokracene hodnoty
      BMovInt64(Jmenovatel, Jm div N);
    end;
  end else raise EDivByZero.Create('Division by zero!');
end;

//------------------------------------------------------------------------------

function TNumber.GetRealValue: Extended;
var X: PRec10;
    Tmp: TDynInt;          
    i, Exp: Integer;
begin
  Result := 0;
  if not BIsZero(Citatel) then begin  // kdyz je to nula tak je vsechno nulove
    X := @Result;                      // nastavime Rec10 na vysledek
    DICreate(Tmp);                     // vytvorime docasny DynInt
    DICopy(Tmp, Citatel);             // a zkopirujeme do nej citatele
    Exp := DynIntBitLength(Tmp) - DynIntBitLength(Jmenovatel) - 64; // zjistime rozdil
    BShr(Tmp, Exp);      // a posumene
    BDiv(Tmp, Tmp, Jmenovatel);       // vydelime; vysledkem je 64 nebo 65 bitu
    if Tmp.Length = 9 then begin
      BShr(Tmp, 1);
      Inc(Exp);
    end;
    for i := 0 to 7 do X.fByte[i] := DIGet(Tmp, i); // zkopirujeme do vysledku
    X.fWord[4] := Exp + 16446; //16382 + Exp + 64;  // nastavime exponent floatu
    if Minus then X.fByte[9] := X.fByte[9] or 128; // a znamenku
  end;
end;

//------------------------------------------------------------------------------

function TNumber.GetHasIntPart: Boolean;
begin
  Result := BGreaterEqual(Citatel, Jmenovatel) or BIsZero(Citatel);
  FreeTemp;
end;

//------------------------------------------------------------------------------

function TNumber.GetIsInt: Boolean;
begin
  Result := BIsOne(Jmenovatel);
end;

//------------------------------------------------------------------------------

function TNumber.GetCanBeInt64: Boolean;
var Diff: Integer;
    Temp, Rem: TDynInt;
begin
  Diff := DynIntBitLength(Citatel) - DynIntBitLength(Jmenovatel);
  if Diff < 63 then Result := true else if Diff < 65 then begin
    if not IsInt then begin
      DICreate(Temp);
      DICreate(Rem);
      BDivMod(Temp, Rem, Citatel, Jmenovatel);
      BShl(Rem, 1);
      if BGreaterEqual(Rem, Citatel) then BInc(Temp);
      Result := DIGet(Temp, 7) and 128 = 0;
      if Minus then Result := Result or (EndingZeros(Temp) = 63); // test na Low Int64
      DIFree(Temp);
      DIFree(Rem);
    end else Result := (DIGet(Citatel, 7) and 128 = 0) or (Minus and (EndingZeros(Citatel) = 63));
  end else Result := false;
end;

//------------------------------------------------------------------------------

function TNumber.GetInt64Value: Int64;
var i: Integer;
    Pom: PRec8;
    Temp, Rem: TDynInt;
begin
  Result := 0;
  Pom := @Result;
  if not BIsOne(Jmenovatel) then begin // kdyz neni cele cislo
    DICreate(Temp);
    DICreate(Rem);
    BDivMod(Temp, Rem, Citatel, Jmenovatel); // podelime citatel jmenovatelem
    BShl(Rem, 1);                            // vynasobime zbytek dvema
    if BGreaterEqual(Rem, Jmenovatel) then BInc(Temp); // a podle toho rozhodneme o zaokrouhleni
    if Minus then begin
      if Temp.Length < 9 then begin
        DIFree(Rem);
        DICreate(Rem, 9);
        DISet(Rem, 8, 1);
        BSub(Rem, Temp);
        if DynIntBitLength(Rem) = 64 then for i := 0 to 7 do Pom.fByte[i] := DIGet(Rem, i)
         else raise EConvertError.Create('too large for Int64');
      end else raise EConvertError.Create('too large for Int64');
    end else begin
      if Temp.Length < 8 then
       for i := 0 to Temp.Length-1 do Pom.fByte[i] := DIGet(Temp, i)
       else if (Temp.Length = 8) and (DIGet(Temp, 7) and 128 = 0) then
       for i := 0 to Temp.Length-1 do Pom.fByte[i] := DIGet(Temp, i)
       else raise EConvertError.Create('too large for Int64');
    end;
    DIFree(Temp);
    DIFree(Rem);
  end else begin  // kdyz je cele cislo - staci prevest citatel
    if Minus then begin
      if Citatel.Length < 9 then begin
        DICreate(Rem, 9);
        DISet(Rem, 8, 1);
        BSub(Rem, Citatel);
        if DynIntBitLength(Rem) = 64 then for i := 0 to 7 do Pom.fByte[i] := DIGet(Rem, i)
         else raise EConvertError.Create('too large for Int64');
        DIFree(Rem); 
      end else raise EConvertError.Create('too large for Int64');
    end else begin
      if Citatel.Length < 8 then
       for i := 0 to Citatel.Length-1 do Pom.fByte[i] := DIGet(Citatel, i)
       else if (Citatel.Length = 8) and (DIGet(Citatel, 7) and 128 = 0) then
       for i := 0 to Citatel.Length-1 do Pom.fByte[i] := DIGet(Citatel, i)
       else raise EConvertError.Create('too large for Int64');
    end;
  end;
end;

//------------------------------------------------------------------------------

procedure TNumber.SetFromHexStr(Hex: String);
var HasMinus: Boolean;
    i, NumType: Integer;
    TmpA, TmpB: TDynInt;
begin
  if Hex <> '' then begin
    if Hex[1] = '-' then begin  // test na znamenko
      HasMinus := true;
      Delete(Hex, 1, 1);        // ktere se odstrani z retezce
    end else HasMinus := false;
    NumType := 0;
    for i := 1 to Length(Hex) do case Hex[i] of
      ',', '.': begin
                  NumType := 1;
                  Break;
                end;
      '/': begin
             NumType := 2;
             Break;
           end;
      '+': begin
             NumType := 3;
             Break;
           end;
    end;
    case NumType of
      0: begin         // jen cele cislo
           HexToDynInt(Citatel, Hex);
           Minus := HasMinus;
           if not BIsOne(Jmenovatel) then begin
             DIFree(Jmenovatel);
             DICreate(Jmenovatel, 1);
             DISet(Jmenovatel, 0, 1);
           end;
         end;
      1: begin         // cislo s carkou
           Delete(Hex, i, 1);
           HexToDynInt(Citatel, Hex);
           DIFree(Jmenovatel);
           DICreate(Jmenovatel, ((Length(Hex) - i + 1) shr 1) + 1);
           if (Length(Hex) - i) and 1 = 1 then
            DISet(Jmenovatel, Jmenovatel.Length-1, 1) else
            DISet(Jmenovatel, Jmenovatel.Length-1, $10);
           CancelFrac(Citatel, Jmenovatel);
           Minus := HasMinus;
         end;
      2: begin          // podilovy tvar
           DICreate(TmpA);
           HexToDynInt(TmpA, Copy(Hex, i + 1, Length(Hex) - i));
           if BIsZero(TmpA) then begin
             DIFree(TmpA);
             raise EDivByZero.Create('divide by zero');
           end;
           HexToDynInt(Citatel, Copy(Hex, 1, i - 1));
           DIFree(Jmenovatel);
           Jmenovatel := TmpA;
           CancelFrac(Citatel, Jmenovatel);
           Minus := HasMinus;
         end;
      3: begin         // tvar A+B/C
           NumType := i;
           for i := i to Length(Hex) do if Hex[i] = '/' then Break; // najdeme lomitko
           if i = Length(Hex) then raise EConvertError.Create('invalid format!');
           DICreate(TmpA);
           HexToDynInt(TmpA, Copy(Hex, i + 1, Length(Hex) - i));
           if BIsZero(TmpA) then begin
             DIFree(TmpA);
             raise EDivByZero.Create('divide by zero');
           end;
           DICreate(TmpB);
           HexToDynInt(TmpB, Copy(Hex, NumType + 1, i - NumType - 1));
           HexToDynInt(Citatel, Copy(Hex, 1, NumType - 1));
           DIFree(Jmenovatel);
           Jmenovatel := TmpA;
           BMul(Citatel, Citatel, Jmenovatel);
           BAdd(Citatel, TmpB);
           DIFree(TmpB);
           CancelFrac(Citatel, Jmenovatel);
           Minus := HasMinus;
         end;
    end;
  end else raise EConvertError.Create('nothing to convert');
end;

//------------------------------------------------------------------------------

procedure TNumber.SetFromDecStr(Dec: String);
var HasMinus: Boolean;
    i, NumType: Integer;
    TmpA, TmpB: TDynInt;
begin
  if Dec <> '' then begin
    if Dec[1] = '-' then begin  // test na znamenko
      HasMinus := true;
      Delete(Dec, 1, 1);        // ktere se odstrani z retezce
    end else HasMinus := false;
    NumType := 0;
    for i := 1 to Length(Dec) do case Dec[i] of
      ',', '.': begin
                  NumType := 1;
                  Break;
                end;
      '/': begin
             NumType := 2;
             Break;
           end;
      '+': begin
             NumType := 3;
             Break;
           end;
    end;
    case NumType of
      0: begin         // jen cele cislo
           StrToDynInt(Citatel, Dec);
           Minus := HasMinus;
           if not BIsOne(Jmenovatel) then begin
             DIFree(Jmenovatel);
             DICreate(Jmenovatel, 1);
             DISet(Jmenovatel, 0, 1);
           end;
         end;
      1: begin         // cislo s carkou
           Delete(Dec, i, 1);
           StrToDynInt(Citatel, Dec);
           DIFree(Jmenovatel);
           DICreate(Jmenovatel, 1);
           DISet(Jmenovatel, 0, 10);
           NumType := Length(Dec) - i;
           if NumType > 0 then begin
             DICreate(TmpA, 1);
             DISet(TmpA, 0, 10);
             for i := 0 to NumType-1 do BMul(Jmenovatel, Jmenovatel, TmpA);
           end;
           CancelFrac(Citatel, Jmenovatel);
           Minus := HasMinus;
         end;
      2: begin          // podilovy tvar
           DICreate(TmpA);
           StrToDynInt(TmpA, Copy(Dec, i + 1, Length(Dec) - i));
           if BIsZero(TmpA) then begin
             DIFree(TmpA);
             raise EDivByZero.Create('divide by zero');
           end;
           StrToDynInt(Citatel, Copy(Dec, 1, i - 1));
           DIFree(Jmenovatel);
           Jmenovatel := TmpA;
           CancelFrac(Citatel, Jmenovatel);
           Minus := HasMinus;
         end;
      3: begin         // tvar A+B/C
           NumType := i;
           for i := i to Length(Dec) do if Dec[i] = '/' then Break;
           if i = Length(Dec) then raise Exception.Create('');
           DICreate(TmpA);
           StrToDynInt(TmpA, Copy(Dec, i + 1, Length(Dec) - i));
           if BIsZero(TmpA) then begin
             DIFree(TmpA);
             raise EDivByZero.Create('divide by zero');
           end;
           DICreate(TmpB);
           StrToDynInt(TmpB, Copy(Dec, NumType + 1, i - NumType - 1));
           StrToDynInt(Citatel, Copy(Dec, 1, NumType - 1));
           DIFree(Jmenovatel);
           Jmenovatel := TmpA;
           BMul(Citatel, Citatel, Jmenovatel);
           BAdd(Citatel, TmpB);
           DIFree(TmpB);
           CancelFrac(Citatel, Jmenovatel);
           Minus := HasMinus;
         end;
    end;
  end else raise EConvertError.Create('nothing to convert');
end;

//------------------------------------------------------------------------------

function TNumber.GetHexCitatel(const UseCaps: Boolean = true): String;
begin
  Result := DynIntToHex(Citatel);
  if not UseCaps then Result := LowerCase(Result);
  //if Minus then Insert('-', Result, 1);
  FreeTemp;
end;

//------------------------------------------------------------------------------

function TNumber.GetDecCitatel: String;
begin
  Result := DynIntToStr(Citatel);
  //if Minus then Insert('-', Result, 1);
  FreeTemp;
end;

//------------------------------------------------------------------------------

function TNumber.GetHexJmenovatel(const UseCaps: Boolean = true): String;
begin
  Result := DynIntToHex(Jmenovatel);
  if not UseCaps then Result := LowerCase(Result);
  FreeTemp;
end;

//------------------------------------------------------------------------------

function TNumber.GetDecJmenovatel: String;
begin
  Result := DynIntToStr(Jmenovatel);
  FreeTemp;
end;

//------------------------------------------------------------------------------

function TNumber.GetHexIntPart(const UseCaps: Boolean = true): String;
var Temp: TDynInt;
begin
  if BIsOne(Jmenovatel) then Result := DynIntToHex(Citatel) else begin
    DICreate(Temp);
    BDiv(Temp, Citatel, Jmenovatel);
    Result := DynIntToHex(Temp);
    DIFree(Temp);
  end;
  if not UseCaps then Result := LowerCase(Result);
  //if Minus then Result := '-' + Result;
  FreeTemp;
end;

//------------------------------------------------------------------------------

function TNumber.GetDecIntPart: String;
var Temp: TDynInt;
begin
  if BIsOne(Jmenovatel) then Result := DynIntToStr(Citatel) else begin
    DICreate(Temp);
    BDiv(Temp, Citatel, Jmenovatel);
    Result := DynIntToStr(Temp);
    DIFree(Temp);
  end;
  //if Minus then Result := '-' + Result;
  FreeTemp;
end;

//------------------------------------------------------------------------------

function TNumber.GetHexRemain(const UseCaps: Boolean = true): String;
var Temp: TDynInt;
begin
  if BIsOne(Jmenovatel) then Result := '0' else begin
    DICreate(Temp);
    BMod(Temp, Citatel, Jmenovatel);
    Result := DynIntToHex(Temp);
    DIFree(Temp);
  end;
  if not UseCaps then Result := LowerCase(Result);
  FreeTemp;
end;

//------------------------------------------------------------------------------

function TNumber.GetDecRemain: String;
var Temp: TDynInt;
begin
  if BIsOne(Jmenovatel) then Result := '0' else begin
    DICreate(Temp);
    BMod(Temp, Citatel, Jmenovatel);
    Result := DynIntToStr(Temp);
    DIFree(Temp);
  end;
  FreeTemp;
end;

//------------------------------------------------------------------------------

function TNumber.GetHexComplete(const MaxDigits: Cardinal; const UseCaps: Boolean = true): String;
var IntPart, Remain, Temp: TDynInt;
    i: Cardinal;
    RemStr: String;
    UseRem: Boolean;
begin
  if BIsOne(Jmenovatel) then Result := GetHexCitatel(UseCaps) else begin
    UseRem := true;
    if Minus then Result := '-';    // znamenko
    DICreate(IntPart);              // tvorba lokalnich
    DICreate(Remain);
    BDivMod(IntPart, Remain, Citatel, Jmenovatel); // podelime citatele a jmenovatele
    BShl(Remain, (MaxDigits + 1) * 4);       // posuneme zbytek, abychom mohli znova delit
    BDiv(Remain, Remain, Jmenovatel);    // podelime
    if DIGet(Remain, 0) and 8 = 8 then begin // rozhodneme o zaokrouhleni
      DICreate(Temp, 1);
      DISet(Temp, 0, 16); // pricteme 16 - zaokrouhleni
      BAdd(Remain, Temp);
      DIFree(Temp);                         //  V   test na preteceni
      if ((MaxDigits and 1 = 1) and (Remain.Length * 2 - 1 > MaxDigits)) or // MaxDigits sude
       ((MaxDigits and 1 = 0) and (DIGet(Remain, Remain.Length-1) and $F0 <> 0) //-II- liche
       and (Remain.Length*2 > MaxDigits)) then begin
        BInc(IntPart);
        UseRem := false;
      end;
    end;
    BShr(Remain, 4); // zrusime posledni cislici
    if UseRem and not BIsZero(Remain) then begin
      RemStr := DynIntToHex(Remain);
      RemStr := StringOfChar('0', MaxDigits - Length(RemStr)) + RemStr; // pridame chybici nuly
      i := Length(RemStr);
      while RemStr[i] = '0' do Dec(i);  // odstranime nuly na konci
      Delete(RemStr, i + 1, Length(RemStr) - i);
      Result := Result + DynIntToHex(IntPart) + DecimalSeparator + RemStr;
    end else Result := Result + DynIntToHex(IntPart);
    if not UseCaps then Result := LowerCase(Result);
    DIFree(IntPart);   // zrusime docasne
    DIFree(Remain);
  end;
  FreeTemp;
end;

//------------------------------------------------------------------------------

function TNumber.GetDecComplete(const MaxDigits: Cardinal): String;
var IntPart, Remain, Cnst10, Temp: TDynInt;
    i: Cardinal;
    RemStr: String;
    UseRem: Boolean;
begin
  if BIsOne(Jmenovatel) then Result := GetDecCitatel else begin
    UseRem := true;
    //if Minus then Result := '-';  // znamenko
    DICreate(IntPart);
    DICreate(Remain);
    BDivMod(IntPart, Remain, Citatel, Jmenovatel); // delime citatel jmenovatelem
    DICreate(Cnst10, 1);
    DISet(Cnst10, 0, 10);
    if MaxDigits = 0 then begin         // kdyz jen cely vysledek
      BMul(Remain, Remain, Cnst10);
      BDiv(Remain, Remain, Jmenovatel);
      BMod(Remain, Remain, Cnst10);
      if DIGet(Remain, 0) > 4 then begin // rozhodneme o zaokrouhleni
        BInc(IntPart);
        UseRem := false;
      end;
    end else begin
      for i := 0 to MaxDigits do BMul(Remain, Remain, Cnst10); // nasobime deseti
      DICreate(Temp);
      BDiv(Remain, Remain, Jmenovatel); // opet delime jmenovatelem
      BDivMod(Remain, Temp, Remain, Cnst10); // ziskame posledni cislici (Temp)
      if DIGet(Temp, 0) > 4 then begin // rozhodneme o zaokrouhleni
        i := 1;
        BDiv(Temp, Remain, Cnst10);
        while not BIsZero(Temp) do begin // spocitame cislice
          Inc(i);
          BDiv(Temp, Temp, Cnst10);
        end;
        BInc(Remain);  // pricteme 1 na konec - zaokrouhleni
        if i = MaxDigits then begin // je mozne preteceni?
          i := 1;
          BDiv(Temp, Remain, Cnst10);
          while not BIsZero(Temp) do begin // opet spocitame cislice
            Inc(i);
            BDiv(Temp, Temp, Cnst10);
          end;
          if i > MaxDigits then begin // srovname pocet cislic - test na preteceni
            BInc(IntPart);
            UseRem := false;
          end;
        end;
      end;
    end;
    if UseRem and not BIsZero(Remain) then begin
      RemStr := DynIntToStr(Remain);
      RemStr := StringOfChar('0', MaxDigits - Length(RemStr)) + RemStr;
      i := Length(RemStr);
      while RemStr[i] = '0' do Dec(i);
      Delete(RemStr, i + 1, Length(RemStr) - i);
      Result := DynIntToStr(IntPart) + DecimalSeparator + RemStr;
    end else Result := DynIntToStr(IntPart);
    DIFree(IntPart);
    DIFree(Remain);
    DIFree(Cnst10);
    DIFree(Temp);
  end;
  if Minus and (Result <> '0') then Result := '-' + Result;
  FreeTemp;
end;

//------------------------------------------------------------------------------

function TNumber.GetHexFract(const UseCaps: Boolean = true): String;
var Temp, Rem: TDynInt;
begin
  if BIsOne(Jmenovatel) then begin
    Result := DynIntToHex(Citatel);
  end else begin
    DICreate(Temp);
    DICreate(Rem);
    BDivMod(Temp, Rem, Citatel, Jmenovatel);
    if BIsZero(Temp) then Result := DynIntToHex(Rem) + '/' + DynIntToHex(Jmenovatel)
     else Result := DynIntToHex(Temp) + '+' + DynIntToHex(Rem) + '/' + DynIntToHex(Jmenovatel);
    DIFree(Temp);
    DIFree(Rem);
  end;
  if not UseCaps then Result := LowerCase(Result);
  if Minus then Result := '-' + Result;
  FreeTemp;
end;

//------------------------------------------------------------------------------

function TNumber.GetDecFract: String;
var Temp, Rem: TDynInt;
begin
  if BIsOne(Jmenovatel) then begin
    Result := DynIntToStr(Citatel);
  end else begin
    DICreate(Temp);
    DICreate(Rem);
    BDivMod(Temp, Rem, Citatel, Jmenovatel);
    if BIsZero(Temp) then Result := DynIntToStr(Rem) + '/' + DynIntToStr(Jmenovatel)
     else Result := DynIntToStr(Temp) + '+' + DynIntToStr(Rem) + '/' + DynIntToStr(Jmenovatel);
    DIFree(Temp);
    DIFree(Rem);
  end;
  if Minus then Result := '-' + Result;
  FreeTemp;
end;

//------------------------------------------------------------------------------
//------------------------------------------------------------------------------

function MulInv(const X: TNumber): TTempNumber;
var Temp: TDynInt;
begin
  if not BIsZero(X.Citatel) then with Result do begin
    if X is TTempNumber then begin
      Result := X as TTempNumber;
      Temp := Citatel;
      Citatel := Jmenovatel;
      Jmenovatel := Temp;
    end else begin
      Result := TTempNumber.Create(false);
      Citatel := X.Jmenovatel;
      Jmenovatel := X.Citatel;
      Minus := X.Minus;
    end;
  end else raise EDivByZero.Create('zero can''t be inversed');
end;

//------------------------------------------------------------------------------

function AddInv(const X: TNumber): TTempNumber;
begin
  if X is TTempNumber then begin
    Result := X as TTempNumber;
    if not BIsZero(Result.Citatel) then Result.Minus := not Result.Minus;
  end else begin
    Result := TTempNumber.Create(false);
    Result.Citatel := X.Citatel;
    Result.Jmenovatel := X.Jmenovatel;
    if not BIsZero(Result.Citatel) then Result.Minus := not X.Minus;
  end;
end;

//------------------------------------------------------------------------------

procedure AAdd(const Target: TNumber; const Addend: TNumber);
var TmpA, TmpB, TmpC: TDynInt;
begin
  DICreate(TmpA);
  DICreate(TmpB);                  // kreace docasnych
  DICreate(TmpC);
  BGcd(TmpC, Target.Jmenovatel, Addend.Jmenovatel); // v TmpC GCD jmenovatelu
  BDiv(TmpA, Target.Jmenovatel, TmpC);              // v TmpA cim musime nasobit Addend
  DICopy(Target.Jmenovatel, TmpA);
  BMul(Target.Jmenovatel, Addend.Jmenovatel, Target.Jmenovatel); // v Target.Jmenovatel je uz vysledny
  BDiv(TmpB, Addend.Jmenovatel, TmpC);  // v TmpB cim musime nasobit Target
  BMul(TmpB, Target.Citatel, TmpB); // v TmpB je ted citatel Targetu po uprave
  BMul(TmpA, Addend.Citatel, TmpA); // a v TmpA Addendu
  if Target.Minus = Addend.Minus then begin   // kdyz maji stejne znamenko
    DICopy(Target.Citatel, TmpA);             // secteme citatele
    BAdd(Target.Citatel, TmpB);
  end else if BGreaterEqual(TmpB, TmpA) then begin  // kdyz je zn. ruzne a je vetsi Target
    DICopy(Target.Citatel, TmpB);         // odecteme
    BSub(Target.Citatel, TmpA);
  end else begin
    Target.Minus := Addend.Minus;            // kdyz je vetsi Addend tak je to naopak
    DICopy(Target.Citatel, TmpA);
    BSub(Target.Citatel, TmpB);
  end;
  CancelFrac(Target.Citatel, Target.Jmenovatel); // pokratime vysledek
  if BIsZero(Target.Citatel) then Target.Minus := false;
  DIFree(TmpA);
  DIFree(TmpB);                          // destrukce docasnych
  DIFree(TmpC);
end;

//------------------------------------------------------------------------------

procedure AMul(const Target: TNumber; const Multiplicant: TNumber);
begin
  Target.Minus := Target.Minus xor Multiplicant.Minus;
  BMul(Target.Citatel, Target.Citatel, Multiplicant.Citatel);
  BMul(Target.Jmenovatel, Target.Jmenovatel, Multiplicant.Jmenovatel);
  CancelFrac(Target.Citatel, Target.Jmenovatel);
  if BIsZero(Target.Citatel) then Target.Minus := false;
end;

//------------------------------------------------------------------------------

function RAdd(Nums: array of TNumber): TTempNumber;
var i: Integer;
begin
  if Length(Nums) > 0 then begin
    if Nums[0] is TTempNumber and (Nums[0] as TTempNumber).FreeMe then // pokud je prvni Temp
     Result := Nums[0] as TTempNumber else begin // tak ho vyuzijeme
      Result := TTempNumber.Create(true);
      Result.Minus := Nums[0].Minus;           // jinak vysledek vytvorime
      DICopy(Result.Citatel, Nums[0].Citatel); // a zkopirujeme do nej prvni
      DICopy(Result.Jmenovatel, Nums[0].Jmenovatel);
      if Nums[0] is TTempNumber then Nums[0].Free;
    end;
    for i := 1 to High(Nums) do begin
      AAdd(Result, Nums[i]);                    // pricteme vsechny v poli
      if Nums[i] is TTempNumber then Nums[i].Free;
    end;
  end else raise Exception.Create('no arguments');
end;

//------------------------------------------------------------------------------

function RAdd(Nums: array of TNumber; const A: Int64; const B: Int64 = 1): TTempNumber;
var Temp: TNumber;
begin
  Result := RAdd(Nums);
  Temp := TNumber.Create;
  Temp.AssignValue(A, B);
  AAdd(Result, Temp);
  Temp.Free;
end;

//------------------------------------------------------------------------------

function RMul(Nums: array of TNumber): TTempNumber;
var i: Integer;
begin
  if Length(Nums) > 0 then begin
    if Nums[0] is TTempNumber and (Nums[0] as TTempNumber).FreeMe then
     Result := Nums[0] as TTempNumber else begin
      Result := TTempNumber.Create(true);           // totozne se scitanim (RAdd)
      Result.Minus := Nums[0].Minus;
      DICopy(Result.Citatel, Nums[0].Citatel);
      DICopy(Result.Jmenovatel, Nums[0].Jmenovatel);
      if Nums[0] is TTempNumber then Nums[0].Free;
    end;
    for i := 1 to High(Nums) do begin
      AMul(Result, Nums[i]);
      if Nums[i] is TTempNumber then Nums[i].Free;
    end;
  end else raise Exception.Create('no arguments');
end;

//------------------------------------------------------------------------------

function RMul(Nums: array of TNumber; const A: Int64; const B: Int64 = 1): TTempNumber;
var Temp: TNumber;
begin
  Result := RMul(Nums);
  Temp := TNumber.Create;
  Temp.AssignValue(A, B);
  AMul(Result, Temp);
  Temp.Free;
end;

//------------------------------------------------------------------------------

function RGreater(const A, B: TNumber): Boolean;
var IntA, IntB, RemA, RemB: TDynInt;
begin
  if A.Minus xor B.Minus then Result := B.Minus else // srovname znamenka
   if BEqual(A.Jmenovatel, B.Jmenovatel) then begin // pri rovnosti jmenovatelu
    if A.Minus then Result := BGreater(B.Citatel, A.Citatel) // srovname citatele
     else Result := BGreater(A.Citatel, B.Citatel);
  end else if BEqual(A.Citatel, B.Citatel) then begin // pri rovnosti citatelu
    if A.Minus then Result := BGreater(A.Jmenovatel, B.Jmenovatel) // srovname
     else Result := BGreater(B.Jmenovatel, A.Jmenovatel);          // jmenovatele
  end else begin
    DICreate(IntA);
    DICreate(IntB);
    DICreate(RemA);
    DICreate(RemB);
    BDivMod(IntA, RemA, A.Citatel, A.Jmenovatel); // jinak podelime
    BDivMod(IntB, RemB, B.Citatel, B.Jmenovatel);
    if BEqual(IntA, IntB) then begin
      BLcm(IntA, A.Jmenovatel, B.Jmenovatel);  // kdyz je vysledek stejny, rozhodnou zbytky
      BDiv(IntB, IntA, A.Jmenovatel);
      BMul(RemA, RemA, IntB);
      BDiv(IntB, IntA, B.Jmenovatel);
      BMul(RemB, RemB, IntB);
      if A.Minus then Result := BGreater(RemB, RemA) else Result := BGreater(RemA, RemB); 
    end else begin
      if A.Minus then Result := BGreater(IntB, IntA) else Result := BGreater(IntA, IntB);
    end;
    DIFree(IntA);
    DIFree(IntB);
    DIFree(RemA);
    DIFree(RemB);
  end;
  if A is TTempNumber then (A as TTempNumber).Free;
  if B is TTempNumber then (B as TTempNumber).Free;
end;

//------------------------------------------------------------------------------

function RGreater(const A: TNumber; const P: Int64; const Q: Int64 = 1): Boolean;
var Temp: TNumber;
begin
  Temp := TNumber.Create;
  Temp.AssignValue(P, Q);
  Result := RGreater(A, Temp);
  Temp.Free;
end;

//------------------------------------------------------------------------------

function RGreaterEqual(const A, B: TNumber): Boolean;
begin
  Result := not RGreater(B, A);
end;

//------------------------------------------------------------------------------

function RGreaterEqual(const A: TNumber; const P: Int64; const Q: Int64 = 1): Boolean;
var Temp: TNumber;
begin
  Temp := TNumber.Create;
  Temp.AssignValue(P, Q);
  Result := RGreaterEqual(A, Temp);
  Temp.Free;
end;

//------------------------------------------------------------------------------

function REqual(const A, B: TNumber): Boolean;
begin
  Result := (A.Minus = B.Minus) and
   BEqual(A.Citatel, B.Citatel) and BEqual(A.Jmenovatel, B.Jmenovatel);
  if A is TTempNumber then (A as TTempNumber).Free;
  if B is TTempNumber then (B as TTempNumber).Free;
end;

//------------------------------------------------------------------------------

function REqual(const A: TNumber; const P: Int64; const Q: Int64 = 1): Boolean;
var Temp: TNumber;
begin
  Temp := TNumber.Create;
  Temp.AssignValue(P, Q);
  Result := REqual(A, Temp);
  Temp.Free;
end;

//------------------------------------------------------------------------------

function RLesser(const A, B: TNumber): Boolean;
begin
  Result := RGreater(B, A);
end;

//------------------------------------------------------------------------------

function RLesser(const A: TNumber; const P: Int64; const Q: Int64 = 1): Boolean;
var Temp: TNumber;
begin
  Temp := TNumber.Create;
  Temp.AssignValue(P, Q);
  Result := RLesser(A, Temp);
  Temp.Free;
end;

//------------------------------------------------------------------------------

function RLesserEqual(const A, B: TNumber): Boolean; overload;
begin
  Result := not RGreater(A, B);
end;

//------------------------------------------------------------------------------

function RLesserEqual(const A: TNumber; const P: Int64; const Q: Int64 = 1): Boolean; overload;
var Temp: TNumber;
begin
  Temp := TNumber.Create;
  Temp.AssignValue(P, Q);
  Result := RLesserEqual(A, Temp);
  Temp.Free;
end;

//------------------------------------------------------------------------------

function RAbs(const A: TNumber): TTempNumber;
begin
  if A is TTempNumber then begin
    Result := A as TTempNumber;
    Result.Minus := false;
  end else begin
    Result := TTempNumber.Create(false);
    Result.Citatel := A.Citatel;
    Result.Jmenovatel := A.Jmenovatel;
    Result.Minus := false;
  end;
end;

//------------------------------------------------------------------------------

function RTrunc(const A: TNumber): TTempNumber;
begin
  if BIsOne(A.Jmenovatel) then begin
    if A is TTempNumber then Result := A as TTempNumber else begin
      Result := TTempNumber.Create(false);
      Result.Citatel := A.Citatel;
      Result.Jmenovatel := A.Jmenovatel;
      Result.Minus := A.Minus;
    end;
  end else begin
    Result := TTempNumber.Create(true);
    BDiv(Result.Citatel, A.Citatel, A.Jmenovatel);
    if not BIsZero(Result.Citatel) then Result.Minus := A.Minus;
    A.FreeTemp;
  end;
end;

//------------------------------------------------------------------------------

function RRound(const A: TNumber): TTempNumber;
var Rem: TDynInt;
begin
  if BIsOne(A.Jmenovatel) then begin
    if A is TTempNumber then Result := A as TTempNumber else begin
      Result := TTempNumber.Create(false);
      Result.Citatel := A.Citatel;
      Result.Jmenovatel := A.Jmenovatel;
      Result.Minus := A.Minus;
    end;
  end else begin
    Result := TTempNumber.Create(true);
    DICreate(Rem);
    BDivMod(Result.Citatel, Rem, A.Citatel, A.Jmenovatel);
    BShl(Rem, 1);
    if BGreaterEqual(Rem, A.Jmenovatel) then BInc(Result.Citatel);
    if not BIsZero(Result.Citatel) then Result.Minus := A.Minus;
    A.FreeTemp;
  end;
end;

//------------------------------------------------------------------------------

function RFloor(const A: TNumber): TTempNumber;
begin
  if BIsOne(A.Jmenovatel) then begin
    if A is TTempNumber then Result := A as TTempNumber else begin
      Result := TTempNumber.Create(false);
      Result.Citatel := A.Citatel;
      Result.Jmenovatel := A.Jmenovatel;
      Result.Minus := A.Minus;
    end;
  end else begin
    Result := TTempNumber.Create(true);
    BDiv(Result.Citatel, A.Citatel, A.Jmenovatel);
    if A.Minus then BInc(Result.Citatel);
    if not BIsZero(Result.Citatel) then Result.Minus := A.Minus;
    A.FreeTemp;
  end;
end;

//------------------------------------------------------------------------------

function RCeil(const A: TNumber): TTempNumber;
begin
  if BIsOne(A.Jmenovatel) then begin
    if A is TTempNumber then Result := A as TTempNumber else begin
      Result := TTempNumber.Create(false);
      Result.Citatel := A.Citatel;
      Result.Jmenovatel := A.Jmenovatel;
      Result.Minus := A.Minus;
    end;
  end else begin
    Result := TTempNumber.Create(true);
    BDiv(Result.Citatel, A.Citatel, A.Jmenovatel);
    if not A.Minus then BInc(Result.Citatel);
    if not BIsZero(Result.Citatel) then Result.Minus := A.Minus;
    A.FreeTemp;
  end;
end;

//------------------------------------------------------------------------------

function RSqr(const X: TNumber): TTempNumber;
var TempCit, TempJmen: TDynInt;
begin
  if X is TTempNumber then begin  // pokud je TTempNumber
    if (X as TTempNumber).FreeMe then begin // kdyz ma "vlastni" pamet
      Result := (X as TTempNumber);         // tak vyuzijeme primo objekt v parametru
      BMul(Result.Citatel, Result.Citatel, Result.Citatel); // a umocnime
      BMul(Result.Jmenovatel, Result.Jmenovatel, Result.Jmenovatel);
    end else begin  // kdyz je jen "odkazem"
      DICreate(TempCit);  // vytvorime nove DynInty pro citatel a jmenovatel
      DICreate(TempJmen);
      BMul(TempCit, X.Citatel, X.Citatel); // umocnime
      BMul(TempJmen, X.Jmenovatel, X.Jmenovatel);
      Result := (X as TTempNumber); // pouzijeme objekt v parametru
      Result.Citatel := TempCit;  // a priradime mu nove Cit. a Jm.
      Result.Jmenovatel := TempJmen; // takze puvodni pamet se zachovava
      Result.FreeMe := true;  // nastavime jako samostatny
    end;
  end else begin // kdyz je normalni TNumber
    Result := TTempNumber.Create(true); // tak vytvorime novy objekt
    BMul(Result.Citatel, X.Citatel, X.Citatel); // a umocnime
    BMul(Result.Jmenovatel, X.Jmenovatel, X.Jmenovatel);
  end;
end;

//------------------------------------------------------------------------------

end.
