(*************************************************************************
 *  ClassBaseU.pas                                                       *
 *  Vladimr Slvik 2005-10                                              *
 *  Delphi 7 Personal                                                    *
 *  cp1250                                                               *
 *                                                                       *
 *  Some parts must be visible before subclassing and implementation     *
 *    while avoiding circular reference -> separate unit with abstract   *
 *    classes from which the actual engine components inherit desired    *
 *    fields. It also includes base class skeleton for tools with gui    *
 *    input handling etc.                                                *
 *                                                                       *
 *  -additional libraries: Graphics32                                    *
 *************************************************************************)

unit ClassBaseU;

{$INCLUDE ..\Switches.inc}
{t default -}

// Can you tell how much I like my newly learned "virtual" ? ;-)

//------------------------------------------------------------------------------

interface

uses GR32, Types, Classes, Controls, GR32_Image,
     ConfigU, ToolOptionsU;

//------------------------------------------------------------------------------

type TPictureEngineBase = class;
     TUndoEngineBase = class;
     // forward declarations

     //.........................................................................

     TUndoEngineBase = class
     protected // fields
       FPosition: Integer;
       FMaxCount: Integer;
       FRestrictCount: Boolean;
     protected // getters
       function GetCount: Integer; virtual; abstract;
       function GetAtEnd: Boolean; virtual; abstract;
       function GetAtStart: Boolean; virtual; abstract;
       function GetRestrictCount: Boolean; virtual; abstract;
     protected // setters 
       procedure SetRestrictCount(Value:Boolean); virtual; abstract;
       procedure SetMaxCount(Value: Integer); virtual; abstract;
     protected // methods
       procedure Crop; virtual; abstract;
     public // methods
       procedure AddStep(const ChangeRect: TRect); virtual; abstract;
       procedure Truncate(const Index: Integer); virtual; abstract;
       procedure Restart; virtual; abstract;
       procedure Undo; virtual; abstract;
       procedure Redo; virtual; abstract;
     published // properties
       property Count: Integer read GetCount;
       property AtEnd: Boolean read GetAtEnd;
       property AtStart: Boolean read GetAtStart;
       property Position: Integer read FPosition;
       property MaxCount: Integer read FMaxCount write SetMaxCount;
       property RestrictCount: Boolean read FRestrictCount write SetRestrictCount;
     end;

     //.........................................................................

     TPictureEngineBase = class
     protected // fields
       FViewport: TImgView32;
       FUndoEngine: TUndoEngineBase;
       FPctOriginal: TBitmap32;
       // THE picture
       FPctOverlay: TBitmap32;
       // separate tool painting place before comitting to actual picture
       FToolOptions: TToolOptions;
       // persistent master for all tools
       FOptions: TSdiEdOptions;
       // local copy of options for tracking changes
       FOnChange: TNotifyEvent;
     protected // getters
       function GetBoundsRect: TRect; virtual; abstract;
     protected // setters
       procedure SetOptions(const Options: TSdiEdOptions); virtual; abstract;
       procedure SetViewport(ANew: TImgView32); virtual; abstract;
     public // methods
       procedure Reloaded; virtual; abstract;
       // whole picture was changed (like loading from disk...)
       procedure RedrawRect(const APlace: TRect); virtual; abstract;
       // update part of viewport
       procedure UpdateRect(const APlace: TRect); virtual; abstract;
       // part of picture changed, update internals
       procedure Paint; virtual; abstract;
       // force flush to viewport
       procedure CommitOverlay(const AWhere: array of TRect); virtual; abstract; 
       // apply overlay to picture
       procedure DiscardOverlay; virtual; abstract;
       // throw away all changes
       procedure CopyOverlay; virtual; abstract;
       // copy original picture to overlay
       procedure Dump; virtual; abstract;
       // debug helper
     published // properties
       property Picture: TBitmap32 read FPctOriginal;
       property Overlay: TBitmap32 read FPctOverlay;
       property Viewport: TImgView32 read FViewport write SetViewport;
       property Options: TSdiEdOptions read FOptions write SetOptions;
       property ToolOptions: TToolOptions read FToolOptions;
       property BoundsRect: TRect read GetBoundsRect;
       property UndoEngine: TUndoEngineBase read FUndoEngine;
       property OnChange: TNotifyEvent read FOnChange write FOnChange;
     end;

//------------------------------------------------------------------------------

type TToolBase = class
       constructor Create(AEngine: TPictureEngineBase); virtual;
     protected
       FEngine: TPictureEngineBase;
       FActive: Boolean; // indication of activity
     published
       property Active: Boolean read FActive;
       procedure Cancel; virtual;
     end;

type TToolClass = class of TToolBase;

//------------------------------------------------------------------------------

type TClickToolBase = class(TToolBase)
     public
       procedure MouseDown(const Button: TMouseButton; const X, Y: Integer;
         const Shift: TShiftState); virtual; abstract;
     end;
// one click tools like floodfill; stateless except for shared data

//------------------------------------------------------------------------------

type TMouseToolBase = class(TClickToolBase)
     protected
       FChangeArea: TRect;
     public
       constructor Create(AEngine: TPictureEngineBase); override;
       procedure MouseMove(const X, Y: Integer; const Shift: TShiftState);
         virtual; abstract;
       procedure MouseDown(const Button: TMouseButton; const X, Y: Integer;
         const Shift: TShiftState); override; abstract;
       procedure MouseUp(const Button: TMouseButton; const X, Y: Integer;
         const Shift: TShiftState); virtual; abstract;
       procedure MouseLeave; virtual; abstract;
     end;
// tools that stay active for longer time
// full set of mouse bindings

//------------------------------------------------------------------------------

type TStaticToolBase = class(TToolBase)
     public
       procedure Act; virtual; abstract;
     end;
// one-shot only tools do not need mouse input at all; stateless except for shared data

//------------------------------------------------------------------------------

implementation

uses CalcUtilU;

//------------------------------------------------------------------------------

constructor TToolBase.Create(AEngine: TPictureEngineBase);
begin
  FEngine:= AEngine;
  FActive:= False;
end;

//------------------------------------------------------------------------------

procedure TToolBase.Cancel; {$I ..\EMPTY.inc}

//------------------------------------------------------------------------------

constructor TMouseToolBase.Create(AEngine: TPictureEngineBase);
begin
  inherited Create(AEngine);
  FChangeArea:= ZeroRect;
end;

//------------------------------------------------------------------------------

end.
