(*************************************************************************
 *  ConstStrU.pas                                                        *
 *  Vladimr Slvik 2005-10                                              *
 *  Delphi 7 Personal                                                    *
 *  cp1250                                                               *
 *                                                                       *
 *  base strings for Shades' translations                                *
 *                                                                       *
 *  -additional libraries: none                                          *
 *************************************************************************)

unit ConstStrU;

interface

const
(*
    The following string constants are externally extracted and must be
    one line. Maximal length for string literals in Delphi is 255 characters.
    Usage of characters that are escaped in gettext catalogs is also bad idea...

    For more information, please read:    doc/translation_system.txt
*)

    {t default -}

    sscVersionString = '6.1.0';

    sscDebugString = '[debug]';

    sscShades = 'Shades';

    {$IFNDEF DEBUG}
    sscAppCap = sscShades + ' - ';
    {$ELSE}
    sscAppCap = sscShades + #32 + sscDebugString + ' - ';
    {$ENDIF}
    // main window caption

    {$IFNDEF DEBUG}
    sscStartAppCap = sscShades + #32 + sscVersionString;
    {$ELSE}
    sscStartAppCap = sscShades + #32 + VersionString + #32 + sscDebugString;
    {$ENDIF}
    // initial main window caption

    sscAboutDlgVersion = sscShades + ' version ' + sscVersionString;

    // ^^ these are not translated and thus can be assembled from parts

//------------------------------------------------------------------------------

    {t default +}

    sscFontName = 'MS Sans Serif';
    sscFixedWidthFontName = 'Courier New';
    // translatable fonts

    sscAlreadyBackColorHex = 'It appears that the picture already contains color $E7FFFF at [0,0].';
    sscAlreadyBackColorDec = 'It appears that the picture already contains color (231,255,255) at [0,0].';
    // dialog question

    sscMsgCapProceed = 'Proceed?';
    sscMsgCapInfo = 'Information';
    sscMsgCapClose = 'Close?';
    sscMsgCapError = 'Error!';
    // dialog captions

    sscReloadInvalid = 'The picture file still exists, but is not valid any more. You can save the picture now, overwriting the old file. Possible failure will not affect the loaded picture, you will be still able to save it as another file. Do you want to save now?';
    sscReloadWarning = 'The picture has been changed! Reloading will remove all changes since last save. Continue?';
    sscReloadNotExists = 'Could not refresh - file does not exist any more.';
    // reload messages

    sscPasteQuestion = 'You are about to paste an image from clipboard. This will replace the current image with the new one. The current picture has not been saved since last changes. Do you want to save it before pasting now?';

    sscErrVCLError = 'VCL error.';
    sscErrHiBlend = 'Highlight blending color is not a valid hexadecimal color representation.';
    sscErrHiSpec = 'Highlight special color is not a valid hexadecimal color representation.';
    sscErrHiPlayerPri = 'Highlight player color 1 is not a valid hexadecimal color representation.';
    sscErrHiPlayerSec = 'Highlight player color 2 is not a valid hexadecimal color representation.';
    sscErrHiWeight = 'Highlight mode picture blending weight is not a number.';
    sscErrNightBlend = 'Night blending color is not a valid hexadecimal color representation.';
    sscErrNightWeight = 'Night mode picture blending weight is not a number.';
    sscErrMouseScrollX = 'Mouse scroll factor [X] is not a number.';
    sscErrMouseScrollY = 'Mouse scroll factor [Y] is not a number.';
    sscErrMouseThreshold = 'Mouse horizontal scroll threshold is not a number.';
    sscErrMaxUndoNotNumber = 'Undo maximal level is not a number.';
    // options back conversion errors

    sscScaNonDarkGrey = 'Non-darkening menu grey';
    sscScaPriPlayerClr = 'Primary player color';
    sscScaSecPlayerClr = 'Secondary player color';
    sscScaTransparentBackground = 'Transparent background';
    sscScaDarkWindowsLitNight = 'Dark windows lit at night';
    sscScaRedLight = 'Red light';
    sscScaGreenLight = 'Green light';
    sscScaYellowLight = 'Yellow light';
    sscScaLightBlueLight = 'Light blue light';
    sscScaDarkBlueLight = 'Dark blue light';
    sscScaPurpleLight = 'Purple light';
    sscScaBlueWndLitNight = 'Blueish windows lit at night';
    sscScaColdWhiteLight = 'Cold white light, reflective glass';
    // color descriptions

    sscExecWaitExitState = 'Shades are waiting for the chosen editor to exit. If you need to, you can manually abort waiting prematurely (or if an error occured) with the button "Cancel".';
    sscExecWaitEditState = 'Shades cannot detect end of editing in the chosen editor. Please click the button "Finished" after you are done with changes and saved the picture there.';
    // external editor waiting dialog

implementation

end.
