(*************************************************************************
 *  NightOptU.pas + NightOptU.dfm                                        *
 *  Vladimr Slvik 2005-10                                              *
 *  Delphi 7 Personal                                                    *
 *  cp1250                                                               *
 *                                                                       *
 *  Quick night darkness choosing form of Shades :                       *
 *    input with check for proper number and fancy picture               *
 *                                                                       *
 *  -additional libraries: none                                          *
 *************************************************************************)

unit NightOptU;

{$INCLUDE Switches.inc}
{t default -}

interface

uses
  SysUtils, Classes, Controls, Forms, StdCtrls, ExtCtrls, ComCtrls;

type
  TNightOptFrm = class(TForm)
    btnOK: TButton;
    btnCancel: TButton;
    Label1: TLabel;
    Image: TImage;
    TrackBar: TTrackBar;
    lblNum: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure btnOKClick(Sender: TObject);
    procedure TrackBarChange(Sender: TObject);
    procedure FormShow(Sender: TObject);
  private
    NewVal: Cardinal;
  public
    function GetInput(const Old: Cardinal): Cardinal;
  end;

var NightOptFrm: TNightOptFrm;

implementation

uses Math,
     ConstStrU, MainU,
     TranslationU, TransGuiU;

{$R *.dfm}

procedure TNightOptFrm.FormCreate(Sender: TObject);
begin
  with Image.Picture, Bitmap do begin
    MainFrm.ImageList.GetBitmap(2, Bitmap); // load from list
    FreeImage; // save resources - no further operations on this bitmap
  end;
  TranslateComponent(Self);
  Font.Name:= Translate(sscFontName);
end;

function TNightOptFrm.GetInput(const Old: Cardinal): Cardinal;
begin
  with TrackBar do begin
    Position:= Old;
    lblnum.Caption:= IntToStr(Position);
    SelEnd:= Old;
  end;
  NewVal:= Old; // not necessary, but may be useful in future against errors etc.
  if ShowModal = mrOk then Result:= NewVal else Result:= Old;
end;

procedure TNightOptFrm.btnOKClick(Sender: TObject);
begin
  NewVal:= EnsureRange(TrackBar.Position, 0, 255);
  ModalResult:= mrOK;
end;

procedure TNightOptFrm.TrackBarChange(Sender: TObject);
begin
  lblNum.Caption:= IntToStr(TrackBar.Position);
end;

procedure TNightOptFrm.FormShow(Sender: TObject);
begin
  TrackBar.SetFocus;
end;

end.
