(*************************************************************************
 *  Shades.dpr                                                           *
 *  Vladimr Slvik 2005-10                                              *
 *  Delphi 7 Personal                                                    *
 *  cp1250                                                               *
 *                                                                       *
 *  project root file of Shades                                          *
 *                                                                       *
 *  -project additional libraries: Graphics32, StatusBarPro, PNGImage    *
 *  -you will need also SpinButton from sample Delphi components         *
 *  -apart from that, my other units                                     *
 *************************************************************************)

program Shades;

{$INCLUDE Switches.inc}
{%File 'Switches.inc'} // for project manager
{t default -}

//------------------------------------------------------------------------------

uses
  // default units:
  Forms,
  //...........................................................................
  // components
  BrushButton in 'Components\BrushButton.pas', // brush selection button
  //...........................................................................
  // non - visual units:
  ConstStrU in 'CoreU\ConstStrU.pas', // strings
  SysLowU in 'CoreU\SysLowU.pas', // system API abstraction
  CoreTypeU in 'CoreU\CoreTypeU.pas', // core constants and simple types
  CoreLowU in 'CoreU\CoreLowU.pas', // core functions (asm)
  RecolorU in 'CoreU\RecolorU.pas', // recoloring functions
  ShadesInOutU in 'CoreU\ShadesInOutU.pas', // png manipulation
  CalcUtilU in 'CoreU\CalcUtilU.pas', // custom math etc.
  ConfigU in 'CoreU\ConfigU.pas', // config data types and manipulation
  ClassBaseU in 'CoreU\ClassBaseU.pas', // common ancestors
  UndoU in 'CoreU\UndoU.pas', // undo engine
  BackgroundEngineU in 'CoreU\BackgroundEngineU.pas', // background engine
  CoreEngineU in 'CoreU\CoreEngineU.pas', // main engine
  ToolOptionsU in 'ToolsU\ToolOptionsU.pas', // tool config
  //...........................................................................
  // tools' units:
  ToolPaintPencilU in 'ToolsU\ToolPaintPencilU.pas', // pencil
  ToolFillU in 'ToolsU\ToolFillU.pas', // classic floodfill
  ToolBkFixU in 'ToolsU\ToolBkFixU.pas', // background correction
  ToolMagicPencilU in 'ToolsU\ToolMagicPencilU.pas', // special remover pencil
  ToolMagicFillU in 'ToolsU\ToolMagicFillU.pas', // special remover fill
  ToolMoverU in 'ToolsU\ToolMoverU.pas', // moving tool
  ToolCleanAllU in 'ToolsU\ToolCleanAllU.pas', // whole picture cleaning tool
  ToolMagicBrushU in 'ToolsU\ToolMagicBrushU.pas', // brush tool
  ToolColorizeU in 'ToolsU\ToolColorizeU.pas', // colorizing tool
  //...........................................................................
  // VCL units:
  ModuleU in 'ModuleU.pas' {DialogModule: TDataModule},
  CbFrameU in 'CbFrameU.pas' {CbFrame: TFrame},
  MainU in 'MainU.pas' {MainFrm},
  AboutU in 'AboutU.pas' {AboutFrm},
  StatU in 'StatU.pas' {StatFrm},
  OptionU in 'OptionU.pas' {OptionFrm},
  ClChgU in 'ClChgU.pas' {ClChgFrm},
  NightOptU in 'NightOptU.pas' {NightOptFrm},
  BackPicU in 'BackPicU.pas' {BackPicFrm};

//------------------------------------------------------------------------------

{$R *.res}

{$R resources/addons.res resources/addons.rc}
// other resources like crane image, help text etc.

//------------------------------------------------------------------------------

begin
  Application.Initialize;
  Application.CreateForm(TMainFrm, MainFrm);
  Application.CreateForm(TAboutFrm, AboutFrm);
  Application.CreateForm(TStatFrm, StatFrm);
  Application.CreateForm(TOptionFrm, OptionFrm);
  Application.CreateForm(TClChgFrm, ClChgFrm);
  Application.CreateForm(TNightOptFrm, NightOptFrm);
  Application.CreateForm(TBackPicFrm, BackPicFrm);
  Application.CreateForm(TDialogModule, DialogModule);
  Application.Title:= 'Shades';
  Application.Run;
end.
