(*************************************************************************
 *  ToolMagicFillU.pas                                                   *
 *  Vladimr Slvik 2009-10                                              *
 *  Delphi 7 Personal                                                    *
 *  cp1250                                                               *
 *                                                                       *
 *  Magic floodfill tool - gets rid of special colour areas.             *
 *                                                                       *
 *  -additional libraries: Graphics32                                    *
 *************************************************************************)

unit ToolMagicFillU;

{$INCLUDE ..\Switches.inc}
{t default -}

//------------------------------------------------------------------------------

interface

uses Classes, ClassBaseU, GR32, Controls;

//------------------------------------------------------------------------------

type TMagicFillTool = class(TClickToolBase)
     public
       procedure MouseDown(const Button: TMouseButton; const X, Y: Integer;
         const Shift: TShiftState); override;
     end;

//==============================================================================
implementation

uses CoreLowU, SysUtils, CoreEngineU, CalcUtilU, GR32_Blend;
//==============================================================================

procedure TMagicFillTool.MouseDown(const Button: TMouseButton; const X, Y: Integer;
  const Shift: TShiftState);
var ActionPlace: TRect;
    C: TColor32;
begin
  if Button = mbLeft then try
    Assert(Assigned(FEngine));
    C:= FEngine.Picture.PixelS[X, Y];
    if not IsSpecialColor(C) then Abort;
    if IsBackgroundColor(C) then Abort;
    if IsPlayerColor(C) and not FEngine.ToolOptions.RemovePlayer then Abort;
    if IsDarkColor(C) and not FEngine.ToolOptions.RemoveGlowing then Abort;
    C:= ColorAdd(C, $FF010101);
    FEngine.CopyOverlay;
    FloodFill32(FEngine.Overlay, Point(X, Y), C, ActionPlace,
      FEngine.ToolOptions.DiagonalFill);
    EMMS;
    FEngine.CommitOverlay(ActionPlace);
    FEngine.RedrawRect(ActionPlace);
  except
    // eat abort
  end;
end;

//------------------------------------------------------------------------------

end.
