(*************************************************************************
 *  ToolMagicPencilU.pas                                                 *
 *  Vladimr Slvik 2009-10                                              *
 *  Delphi 7 Personal                                                    *
 *  cp1250                                                               *
 *                                                                       *
 *  Magic pencil tool - removes special colours by painting over them.   *
 *                                                                       *
 *  -additional libraries: Graphics32                                    *
 *************************************************************************)

unit ToolMagicPencilU;

{$INCLUDE ..\Switches.inc}
{t default -}

//------------------------------------------------------------------------------

interface

uses Classes, ClassBaseU, GR32, Controls;

//------------------------------------------------------------------------------

type TMagicPencilTool = class(TMouseToolBase)
     public
       procedure MouseMove(const X, Y: Integer; const Shift: TShiftState);
         override;
       procedure MouseDown(const Button: TMouseButton; const X, Y: Integer;
         const Shift: TShiftState); override;
       procedure MouseUp(const Button: TMouseButton; const X, Y: Integer;
         const Shift: TShiftState); override;
       procedure MouseLeave; override;
       procedure Cancel; override;
     end;

//==============================================================================
implementation

uses CoreLowU, SysUtils, CoreEngineU, CalcUtilU, GR32_Blend;
//==============================================================================

procedure TMagicPencilTool.MouseMove(const X, Y: Integer; const Shift: TShiftState);
var R: TRect;
    C: TColor32;
begin
  if FActive then try
    Assert(Assigned(FEngine));
    C:= FEngine.Picture.PixelS[X, Y];
    if not IsSpecialColor(C) then Abort;
    if IsBackgroundColor(C) then Abort;
    if IsPlayerColor(C) and not FEngine.ToolOptions.RemovePlayer then Abort;
    if IsDarkColor(C) and not FEngine.ToolOptions.RemoveGlowing then Abort;
    C:= ColorAdd(C, $FF010101);
    EMMS;
    FEngine.Overlay.PixelS[X, Y]:= C;
    R:= Rect(X - 1, Y - 1, X + 2, Y + 2);
    FChangeArea:= AccumulateRect(FChangeArea, R);
    FEngine.UpdateRect(R);
    FEngine.RedrawRect(R);
  except
    // eat aborts
  end;
end;

//------------------------------------------------------------------------------

procedure TMagicPencilTool.MouseDown(const Button: TMouseButton;
    const X, Y: Integer; const Shift: TShiftState);
begin
  if (not FActive) and (Button = mbLeft) then begin // this one starts activity
    Assert(Assigned(FEngine));
    FActive:= True; // activate
    Self.MouseMove(X, Y, Shift); // and paint the first pixel
  end else if FActive and (Button = mbRight) then begin
    // stop activity
    Cancel;
  end;
end;

//------------------------------------------------------------------------------

procedure TMagicPencilTool.MouseUp(const Button: TMouseButton;
    const X, Y: Integer; const Shift: TShiftState);
begin
  if FActive and (Button = mbLeft) then begin
    FActive:= False;
    FEngine.CommitOverlay(FChangeArea);
    FEngine.RedrawRect(FChangeArea);
    FChangeArea:= ZeroRect;
  end;
end;

//------------------------------------------------------------------------------

procedure TMagicPencilTool.MouseLeave; {$I EMPTY.inc}
// do not react, keep painting

//------------------------------------------------------------------------------

procedure TMagicPencilTool.Cancel;
begin
  if FActive then begin
    FActive:= False;
    FEngine.DiscardOverlay;
    FEngine.UpdateRect(FChangeArea);
    FEngine.RedrawRect(FChangeArea);
    FChangeArea:= ZeroRect;
  end;
end;

//------------------------------------------------------------------------------

end.
