unit MainU;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, SysImg, ImgList, ComCtrls, Menus, XPMan;

type
  TMainFrm = class(TForm)
    OpenDialog: TOpenDialog;
    btnAdd: TButton;
    btnRemove: TButton;
    btnOk: TButton;
    btnCancel: TButton;
    SaveDialog: TSaveDialog;
    SysImageList: TSysImageList;
    ListView: TListView;
    AddFilesPM: TPopupMenu;
    pmFoldCont: TMenuItem;
    pmMask: TMenuItem;
    XPManifest: TXPManifest;
    RemFilesPM: TPopupMenu;
    withPath1: TMenuItem;
    withName1: TMenuItem;
    procedure btnAddClick(Sender: TObject);
    procedure btnRemoveClick(Sender: TObject);
    procedure btnCancelClick(Sender: TObject);
    procedure btnOkClick(Sender: TObject);
    procedure OnThreadEnd(Sender: TObject);
    procedure EnableButtons(const Enable: Boolean);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure FormCreate(Sender: TObject);
    procedure ListViewKeyUp(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure ListViewDrawItem(Sender: TCustomListView; Item: TListItem;
      Rect: TRect; State: TOwnerDrawState);
    procedure ListViewContextPopup(Sender: TObject; MousePos: TPoint;
      var Handled: Boolean);
    procedure FormDestroy(Sender: TObject);
    procedure pmMaskClick(Sender: TObject);
    procedure pmFoldContClick(Sender: TObject);
    procedure withPath1Click(Sender: TObject);
  private
    FCanShutDown: Boolean;
    FOldLBWndProc: TWndMethod;
    procedure FAddToLB(const FileName: String; FilePath: String = '');
    procedure FNewLBWndProc(var Message: TMessage);
    procedure HandleDrop(var Msg: TWMDropFiles);
    function FileNameMatchesMask(const FileName, Mask: String): Boolean;  
  public
  end;


var
  MainFrm: TMainFrm;

implementation

uses LibTar, Bzip2, ShellAPI, FileCtrl, StrUtils;

const FewDots = '...';

var PersistIcon: TIcon; // better to have it global instead of local in draw routine
    CharLenArr: Array [Char] of Word; // keeping all chars' lenght for faster access

{$R *.dfm}

type TCompressThread = class(TThread)
      GoCompress: Boolean;
      ErrorMessage: String;
      constructor Create(const Files: TListItems; const Target: String);
      destructor Destroy; override;
      procedure Execute; override;
     private
      FFiles: TList;
      FTarget: String;
     end;

type TFileListData =class
      RelPath: String;
      constructor Create(const Path: String);
     end;

constructor TFileListData.Create(const Path: String);
begin
 inherited Create;
 RelPath:= Path;
end;


constructor TCompressThread.Create(const Files: TListItems; const Target: String);
var i: Integer;
begin
 inherited Create(true);
 FFiles:= TList.Create;
 for i:=0 to Files.Count-1 do FFiles.Add(Files.Item[i]);
 FTarget:= Target;
 FreeOnTerminate:= true;
 Onterminate:= MainFrm.OnThreadEnd;
 resume;
end;

destructor TCompressThread.Destroy;
begin
 FFiles.Free;
end;

procedure TCompressThread.Execute;
var Tar: TTarWriter;
    Bzip: TBZip2;
    Dummy, OutFile, F: TFileStream;
    i: Integer;
    tempPath, S: String;
    FilesSize, FS, DriveFree: Int64;
    CurrItem: TListItem;
begin
 temppath:= GetEnvironmentVariable('Temp');
 if tempPath[Length(tempPath)] <> '\' then
  tempPath:= tempPath + '\';

 FilesSize:= 0;
 GoCompress:= true;
 DriveFree:= DiskFree(Ord(UpperCase(tempPath)[1])-64);
 with FFiles do for i:= 0 to Count-1 do
  begin
   try
    try
     F:= TFileStream.Create(TListItem(Items[i]).Caption,fmOpenRead);
     FS:= F.Size;
    except on E: EFOpenError do
     begin
      GoCompress:= False;
      ErrorMessage:= 'File "'+TListItem(Items[i]).Caption+'" cannot be opened.';
      Break;
     end;
    end;
   finally
    F.Free;
   end;
   inc(FilesSize,FS);
  end;
 if FilesSize+1024 > DriveFree then
  begin
   GoCompress:= false;
   ErrorMessage:= 'Not enough space for disk operations.';
  end;
 if GoCompress then
  begin
   Bzip:= TBZip2.Create;
   Dummy:= TFileStream.Create(tempPath+'SsuArcMake.tmp',fmCreate);
   OutFile:= TFileStream.Create(FTarget,fmCreate);
   Tar:= TTarWriter.Create(Dummy);

   with FFiles do for i:=0 to Count-1 do begin
    CurrItem:= Items[i];
    S:= TFileListData(CurrItem.Data).RelPath;
    if (Length(S)>0) and not (S[Length(S)] in ['/','\']) then S:= S + '/';
    Tar.AddFile(CurrItem.Caption,
     S+ExtractFileName(CurrItem.Caption));
   end;
   Tar.Finalize;
   Bzip.CompressStream(Dummy,OutFile);

   BZip.Free;
   Tar.Free;
   Dummy.Free;
   OutFile.Free;
   DeleteFile(tempPath+'SsuArcMake.tmp');
  end;
end;

//------------------------------------------------------------------------------

procedure TMainFrm.FAddToLB(const FileName: String; FilePath: String = '');
var item: TListItem;
begin
  Item:= ListView.Items.Add;
  with Item do begin
   Caption:= FileName;
   Data:= TFileListData.Create(FilePath); // EmptyStr
   ImageIndex:= SysImageList.ImageIndexOf(FileName,True);
  end;
end;

procedure TMainFrm.btnAddClick(Sender: TObject);
var //Item: TListItem;
    i: Integer;
begin
 with OpenDialog do if Execute then for i:=0 to Files.Count-1 do
  FAddToLB(Files.Strings[i]);
end;

procedure TMainFrm.btnRemoveClick(Sender: TObject);
var i,j: Integer;
begin
 with ListView do begin
  for i:= 1 to SelCount do
   for j:= 0 to Items.Count-1 do
    if Items[j].Selected then
     begin
      Items.Delete(j);
      Break;
     end;
 end;
end;

procedure TMainFrm.btnCancelClick(Sender: TObject);
begin
 Close;
end;

procedure TMainFrm.btnOkClick(Sender: TObject);
begin
 if (ListView.Items.Count >0) then begin
  if SaveDialog.Execute then begin
   MainFrm.EnableButtons(false);
   FCanShutDown:= false;
   TCompressThread.Create(ListView.Items,SaveDialog.FileName);
  end;
 end else ShowMessage('Nothing to compress!');
end;

procedure TMainFrm.OnThreadEnd(Sender: TObject);
var T: TCompressThread;
begin
 FCanShutDown:= true;
 Beep;
 T:= Sender as TCompressThread;
 if T.GoCompress then
  Application.MessageBox('Compression succesfully finished.',
   'Info',MB_OK+MB_ICONINFORMATION)
 else
  Application.MessageBox(PChar('Error occured: '+T.ErrorMessage),
   'Info',MB_OK+MB_ICONERROR);
 MainFrm.EnableButtons(true);
end;

procedure TMainFrm.EnableButtons(const Enable: Boolean);
var i: integer;
begin
 for i:=0 to ComponentCount-1 do if Components[i] is TButton then
  (Components[i] as TButton).Enabled:= Enable;
end;

procedure TMainFrm.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
begin
 CanClose:= FCanShutDown;
end;

procedure TMainFrm.FormCreate(Sender: TObject);
var c: Char;
begin
 FCanShutDown:= true;
 if CharLenArr['A'] = 0 then with ListView.Canvas do
  for c:= Low(CharLenArr) to High(CharLenArr) do
   CharLenArr[c]:= TextWidth(c);
 FOldLBWndProc:= ListView.WindowProc;
 ListView.WindowProc:= FNewLBWndProc;
 DragAcceptFiles(ListView.Handle,True);
end;


procedure TMainFrm.ListViewKeyUp(Sender: TObject; var Key: Word;
  Shift: TShiftState);
var i: Integer;
begin
 if btnAdd.Enabled then case Key of // only if buttons enabled - scrolling remains
  ord('a'), ord('A'): if ssCtrl in Shift then ListView.SelectAll;
  VK_DELETE: btnRemoveClick(Sender);
  VK_MULTIPLY: with ListView.Items do for i:=0 to Count-1 do
                Item[i].Selected:= not Item[i].Selected;
 end;
end;

procedure TMainFrm.ListViewDrawItem(Sender: TCustomListView;
  Item: TListItem; Rect: TRect; State: TOwnerDrawState);
var DispCaption, DispPath, PathTmp: String;
    CapLen, PthLen, MinCapLen, MinPthLen, StrCapLen, StrPthLen: Integer;
begin
 // load image of item to global icon
 SysImageList.GetIcon(Item.ImageIndex,PersistIcon);
 // temp str for path, better than the ugly construct to obtain it
 PathTmp:= TFileListData(Item.Data).RelPath;
 // init numbers
 CapLen:= 0; StrCapLen:= 0;
 PthLen:= 0; StrPthLen:= 0;
 with Sender.Canvas do begin // context of many routines is now canvas!
  // now let's look closely at caption
  if TextWidth(Item.Caption)+16 > Sender.Column[0].Width then begin // too long
   MinCapLen:= 16 + TextWidth(FewDots); // icon plus additional mess
   CapLen:= MinCapLen; // we're about to start with the minimal lenght
   repeat
    inc(StrCapLen); // inc counter of char index in caption string
    // inc possible lenght by the char at ^
    inc(CapLen,CharLenArr[Item.Caption[StrCapLen]]);
   until CapLen > Sender.Column[0].Width; // when it's too long, stop ...
   // and just copy it to caption str for display without the last char
   DispCaption:= Copy(Item.Caption,1,StrCapLen-2) + FewDots;
  end else DispCaption:= Item.Caption; // not too long
  // and now the same with path; only leave out icon's 16px
  if TextWidth(PathTmp) > Sender.Column[1].Width then begin
   MinPthLen:= TextWidth(FewDots);
   PthLen:= MinPthLen;
   repeat
    inc(StrPthLen);
    inc(PthLen,CharLenArr[Item.Caption[StrPthLen]]);
   until PthLen > Sender.Column[1].Width;
   DispPath:= Copy(PathTmp,1,StrPthLen-1) + FewDots;
  end else DispPath:= PathTmp;
  // finished playing with preparations, draw stuff
  if odSelected in State then begin 
   Brush.Color:= clHighlight;
   FillRect(Rect);
   Font.Color:= clHighlightText;
   TextOut(Rect.Left+16,Rect.Top,DispCaption);
   TextOut(Rect.Left+Sender.Column[0].Width,Rect.Top,DispPath);
   Draw(Rect.Left,Rect.Top,PersistIcon);
  end else begin
   Brush.Color:= clWindow;
   FillRect(Rect);
   TextOut(Rect.Left+16,Rect.Top,DispCaption);
   TextOut(Rect.Left+Sender.Column[0].Width,Rect.Top,DispPath);
   Draw(Rect.Left,Rect.Top,PersistIcon);
  end;
 end; 
end;

procedure TMainFrm.ListViewContextPopup(Sender: TObject; MousePos: TPoint;
  var Handled: Boolean);
var RelItmPos, RelY, ItmPos, I: Integer;
    OldPath, NewPath: String;
begin
 Handled:= True;
 if btnAdd.Enabled then with ListView do if Items.Count > 0 then begin
  RelItmPos:= TopItem.Index;
  RelY:= ScreenToClient(Mouse.CursorPos).Y - 17;
  ItmPos:= (RelY div 17) + RelItmPos;
  if (ItmPos < Items.Count) and Items[ItmPos].Selected then begin
   NewPath:= InputBox('Edit path','Edit path for selected items. "%s" stands for old item path.','%s');
   if NewPath<>'%s' then begin
    for i:=0 to Items.Count-1 do if Items[i].Selected then begin
     OldPath:= TFileListData(Items[i].Data).RelPath;
     TFileListData(Items[i].Data).RelPath:= Format(NewPath,[OldPath]);
    end;
    Repaint;
   end;
  end;
 end;
end;

procedure TMainFrm.HandleDrop(var Msg: TWMDropFiles);
var S: PChar;
    i, Count, Size: Integer;
begin
 S:= '';
 Count:= DragQueryFile(Msg.Drop,$FFFFFFFF,S,255);
 for i:=0 to Count-1 do begin
  Size := DragQueryFile(Msg.Drop,i,nil,0)+1;
  S:= StrAlloc(Size);
  DragQueryFile(Msg.Drop,i,S,Size);
  if FileExists(S) then FAddToLB(S);
  StrDispose(S);
 end;
 DragFinish(Msg.Drop);
end;

procedure TMainFrm.FNewLBWndProc(var Message: TMessage);
begin
 if Message.Msg = WM_DROPFILES then HandleDrop(TWMDropFiles(Message));
 FOldLBWndProc(Message);
end;

procedure TMainFrm.FormDestroy(Sender: TObject);
begin
 DragAcceptFiles(ListView.Handle,False);
end;

procedure TMainFrm.pmMaskClick(Sender: TObject);
var AddSpec, WorkPath: String;
    NewFiles: TStringList;
    FileAttrs, i: Integer;
    sr: TSearchRec;
begin
 if InputQuery('Add files','Enter file name mask:',AddSpec) then begin
  NewFiles:= TStringList.Create;
  FileAttrs:= faReadOnly + faArchive + faSysFile;
  WorkPath:= ExtractFilePath(AddSpec);
  if FindFirst(AddSpec, FileAttrs, sr) = 0 then begin
   repeat if (sr.Attr and FileAttrs) = sr.Attr then
    NewFiles.Add(WorkPath + Sr.Name);
   until FindNext(sr) <> 0;
   FindClose(sr);
  end;
  with NewFiles do if Count>0 then for i:=0 to Count-1 do
   FAddToLB(Strings[i]);
  NewFiles.Free;
 end;
end;

procedure TMainFrm.pmFoldContClick(Sender: TObject);
var AddSpec, WorkPath, FileName, FileFolder: String;
    NewFiles: TStringList;
    FileAttrs, i, bsPos, Len: Integer;
    sr: TSearchRec;
begin
 if SelectDirectory('Select folder to add',EmptyStr,AddSpec) then begin
  Len:= Length(AddSpec);
  if AddSpec[Len]='\' then AddSpec:= AddSpec + '*.*' else AddSpec:= AddSpec + '\*.*';
  NewFiles:= TStringList.Create;
  FileAttrs:= faReadOnly + faArchive + faSysFile;
  WorkPath:= ExtractFilePath(AddSpec);
  if FindFirst(AddSpec, FileAttrs, sr) = 0 then begin
   repeat if (sr.Attr and FileAttrs) = sr.Attr then
    NewFiles.Add(WorkPath + Sr.Name);
   until FindNext(sr) <> 0;
   FindClose(sr);
  end;
  with NewFiles do if Count>0 then for i:=0 to Count-1 do begin
   FileName:= Strings[i];
   FileFolder:= ExtractFileDir(FileName);
   Len:= Length(FileFolder);   
   if FileFolder[Len-1]<>':' then begin // must not be in root
    bsPos:= LastDelimiter('\',FileFolder);
    FileFolder:= Copy(FileFolder,bsPos+1,Len-bsPos);
    FAddToLB(FileName,FileFolder);
   end else FAddToLB(FileName);
  end; 
  NewFiles.Free;
 end;
end;

function TMainFrm.FileNameMatchesMask(const FileName, Mask: String): Boolean;
var i, len: Integer;
begin
 Result:= True;
 len:= Length(FileName);
 if len<Length(Mask) then Result:= False
 else for i:=1 to Length(Mask) do case Mask[i] of
  '?': ; // just pass
  '*': begin // rest is OK now
        Result:= True;
        Break;
       end;
  else if Mask[i] <> FileName[i] then begin
        Result:= False;
        Break;
       end;
 end;
end;

procedure TMainFrm.withPath1Click(Sender: TObject);
var Mask: String;
begin
 if InputQuery('Enter path mask','Enter path mask',Mask) then begin
  

 end;
end;

initialization
 PersistIcon:= TIcon.Create;
finalization
 PersistIcon.Free;
end.
